/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.ParticleSteamCloud;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleSteamJet;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class SteamJetEffect
extends JetEffect {
    public SteamJetEffect(int chance) {
        super(chance);
    }

    protected static int lavaCount(IBlockAccessEx provider, BlockPos pos, boolean fastCheck) {
        int blockCount = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    IBlockState theBlock = provider.getBlockState(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                    if (!ParticleSteamCloud.isHotBlock(theBlock)) continue;
                    if (fastCheck) {
                        return 1;
                    }
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.STEAM_JET;
    }

    public static boolean isValidSpawnBlock(@Nonnull IBlockAccessEx provider, @Nonnull BlockPos pos) {
        return SteamJetEffect.isValidSpawnBlock(provider.func_180495_p(pos), provider, pos);
    }

    public static boolean isValidSpawnBlock(@Nonnull IBlockState state, @Nonnull IBlockAccessEx provider, @Nonnull BlockPos pos) {
        if (!state.func_185904_a().func_76224_d() || !provider.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        return SteamJetEffect.lavaCount(provider, pos, true) > 0;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return SteamJetEffect.isValidSpawnBlock(state, provider, pos) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = SteamJetEffect.lavaCount(provider, pos, false);
        float spawnHeight = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)provider, (BlockPos)pos);
        ParticleSteamJet effect = new ParticleSteamJet(strength, provider.getWorld(), (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5);
        this.addEffect(effect);
    }
}

