/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.aurora.AuroraBand;
import org.orecruncher.dsurround.client.aurora.AuroraColor;
import org.orecruncher.dsurround.client.aurora.AuroraFactory;
import org.orecruncher.dsurround.client.aurora.AuroraLifeTracker;
import org.orecruncher.dsurround.client.aurora.IAurora;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.registry.dimension.DimensionData;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class AuroraBase
implements IAurora {
    protected final Random random;
    protected final AuroraBand band;
    protected final int bandCount;
    protected final float offset;
    protected final AuroraLifeTracker tracker;
    protected final AuroraColor colors;

    public AuroraBase(long seed) {
        this(seed, false);
    }

    public AuroraBase(long seed, boolean flag) {
        this((Random)new XorShiftRandom(seed), flag);
    }

    public AuroraBase(Random rand, boolean flag) {
        this.random = rand;
        this.bandCount = this.random.nextInt(3) + 1;
        this.offset = this.random.nextInt(20) + 20;
        this.colors = AuroraColor.get(this.random);
        AuroraFactory.AuroraGeometry geo = AuroraFactory.AuroraGeometry.get(this.random);
        this.band = new AuroraBand(this.random, geo, flag, flag);
        this.tracker = new AuroraLifeTracker(512, 1);
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.isAlive();
    }

    protected float getAlpha() {
        return this.tracker.ageRatio() * (float)this.band.getAlphaLimit() / 255.0f;
    }

    protected double getTranslationX(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g.field_70165_t - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
    }

    protected double getTranslationZ(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g.field_70161_v - 150.0 - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
    }

    protected double getTranslationY(float partialTick) {
        DimensionData dimInfo = EnvironStateHandler.EnvironState.getDimensionInfo();
        Minecraft mc = Minecraft.func_71410_x();
        double heightScale = 1.0;
        if (mc.field_71439_g.field_70163_u > (double)dimInfo.getSeaLevel()) {
            double limit = (double)(dimInfo.getSkyHeight() + dimInfo.getCloudHeight()) / 2.0;
            double d1 = limit - (double)dimInfo.getSeaLevel();
            double d2 = mc.field_71439_g.field_70163_u - (double)dimInfo.getSeaLevel();
            heightScale = (d1 - d2) / d1;
        }
        return 64.0 * heightScale;
    }

    @Nonnull
    protected Color getBaseColor() {
        return this.colors.baseColor;
    }

    @Nonnull
    protected Color getFadeColor() {
        return this.colors.fadeColor;
    }

    @Nonnull
    protected Color getMiddleColor() {
        return this.colors.middleColor;
    }

    @Override
    public abstract void render(float var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("bands: ").append(this.bandCount);
        builder.append(", off: ").append(this.offset);
        builder.append(", len: ").append(this.band.length);
        builder.append(", base: ").append(this.getBaseColor().toString());
        builder.append(", fade: ").append(this.getFadeColor().toString());
        builder.append(", alpha: ").append((int)(this.getAlpha() * 255.0f));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }
}

