/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.command;

import com.cazsius.solcarrot.command.CommandClearFoodList;
import com.cazsius.solcarrot.command.CommandSizeFoodList;
import com.cazsius.solcarrot.command.CommandSyncFoodList;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public final class CommandFoodList
extends CommandTreeBase {
    private static final String name = "foodlist";

    public CommandFoodList() {
        this.addSubcommand((ICommand)new CommandSizeFoodList());
        this.addSubcommand((ICommand)new CommandClearFoodList());
        this.addSubcommand((ICommand)new CommandSyncFoodList());
    }

    public String func_71517_b() {
        return name;
    }

    public String func_71518_a(ICommandSender sender) {
        return Localization.keyString("command", this.func_71517_b() + ".usage");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    private static EntityPlayer getPlayerEntity(ICommandSender sender) throws SyntaxErrorException {
        Entity senderEntity = sender.func_174793_f();
        if (!(senderEntity instanceof EntityPlayer)) {
            throw new SyntaxErrorException("commands.generic.player.unspecified", new Object[0]);
        }
        return (EntityPlayer)senderEntity;
    }

    static /* synthetic */ EntityPlayer access$000(ICommandSender x0) throws SyntaxErrorException {
        return CommandFoodList.getPlayerEntity(x0);
    }

    public static abstract class SubCommand
    extends CommandBase {
        public String func_71518_a(ICommandSender sender) {
            return Localization.keyString("command", this.localizationPath("usage"));
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length < 2) {
                return SubCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return Collections.emptyList();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayer player;
            if (args.length > 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args.length == 1) {
                player = SubCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                if (!player.equals((Object)sender.func_174793_f()) && !sender.func_70003_b(2, this.func_71517_b())) {
                    SubCommand.showMessage(sender, Localization.localizedComponent("command", "foodlist.no_permissions", new Object[0]), TextFormatting.RED);
                    return;
                }
            } else {
                player = CommandFoodList.getPlayerEntity(sender);
            }
            this.execute(sender, player, FoodList.get(player));
        }

        abstract void execute(ICommandSender var1, EntityPlayer var2, FoodList var3);

        final ITextComponent localizedComponent(String path, Object ... args) {
            return Localization.localizedComponent("command", this.localizationPath(path), args);
        }

        final ITextComponent localizedQuantityComponent(String path, int number) {
            return Localization.localizedQuantityComponent("command", this.localizationPath(path), number);
        }

        static void showMessage(ICommandSender sender, ITextComponent message, TextFormatting color) {
            Style style = new Style().func_150238_a(color);
            sender.func_145747_a(message.func_150255_a(style));
        }

        static void showMessage(ICommandSender sender, ITextComponent message) {
            SubCommand.showMessage(sender, message, TextFormatting.DARK_AQUA);
        }

        private String localizationPath(String path) {
            return "foodlist." + this.func_71517_b() + "." + path;
        }
    }
}

