/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.client.FoodItemStacks;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
final class FoodData {
    public final FoodList foodList;
    public final ProgressInfo progressInfo;
    public final List<ItemStack> validFoods;
    public final List<ItemStack> eatenFoods;
    public final List<ItemStack> uneatenFoods;

    FoodData(FoodList foodList) {
        this.foodList = foodList;
        this.progressInfo = foodList.getProgressInfo();
        this.validFoods = FoodItemStacks.getAllFoods().stream().filter(this.progressInfo.configInfo::isHearty).collect(Collectors.toList());
        this.eatenFoods = new ArrayList<ItemStack>();
        this.uneatenFoods = new ArrayList<ItemStack>();
        for (ItemStack food : this.validFoods) {
            (foodList.hasEaten(food) ? this.eatenFoods : this.uneatenFoods).add(food);
        }
    }
}

