/*
 * Decompiled with CFR 0.152.
 */
package lumien.quickleafdecay.config;

import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class QuickLeafDecayConfig {
    Property decaySpeedProperty;
    public int decaySpeed;
    Property decayFuzzProperty;
    public int decayFuzz;
    Property playerDecayProperty;
    public boolean playerDecay;
    Configuration config;

    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.decaySpeedProperty = this.config.get("Settings", "DecaySpeed", 7, "The Speed at which Leaves Decay Higher->Slower");
        this.decayFuzzProperty = this.config.get("Settings", "DecayFuzz", 7, "How random will the leaf decay be? Higher->More Random");
        this.playerDecayProperty = this.config.get("Settings", "PlayerDecay", true, "If set to true only trees broken by players will quickly decay.");
        this.syncConfig();
    }

    public void syncConfig() {
        this.decaySpeed = this.decaySpeedProperty.getInt();
        this.decayFuzz = this.decayFuzzProperty.getInt();
        this.playerDecay = this.playerDecayProperty.getBoolean();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public String getString() {
        return this.config.toString();
    }

    public List<IConfigElement> getConfigElements() {
        return new ConfigElement(this.config.getCategory("settings")).getChildElements();
    }
}

