/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.client;

import com.creativemd.opf.OPFrame;
import com.creativemd.opf.client.AnimatedPictureTexture;
import com.creativemd.opf.client.OrdinaryTexture;
import com.creativemd.opf.client.PictureTexture;
import com.creativemd.opf.client.ProcessedImageData;
import com.creativemd.opf.client.cache.TextureCache;
import com.madgag.gif.fmsware.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class DownloadThread
extends Thread {
    public static final Logger LOGGER = LogManager.getLogger(OPFrame.class);
    public static final TextureCache TEXTURE_CACHE = new TextureCache();
    public static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final Object LOCK = new Object();
    public static final int MAXIMUM_ACTIVE_DOWNLOADS = 5;
    public static int activeDownloads = 0;
    public static HashMap<String, PictureTexture> loadedImages = new HashMap();
    public static Set<String> loadingImages = new HashSet<String>();
    private String url;
    private ProcessedImageData processedImage;
    private String error;
    private boolean complete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadThread(String url) {
        this.url = url;
        Object object = LOCK;
        synchronized (object) {
            loadingImages.add(url);
            ++activeDownloads;
        }
        this.setName("OPF Download \"" + url + "\"");
        this.setDaemon(true);
        this.start();
    }

    public boolean hasFinished() {
        return this.complete;
    }

    public boolean hasFailed() {
        return this.hasFinished() && this.error != null;
    }

    public String getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception exception = null;
        try {
            ByteArrayInputStream in;
            block14: {
                byte[] data = DownloadThread.load(this.url);
                String type = DownloadThread.readType(data);
                in = null;
                try {
                    in = new ByteArrayInputStream(data);
                    if (type.equalsIgnoreCase("gif")) {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            this.processedImage = new ProcessedImageData(gif);
                        } else {
                            LOGGER.error("Failed to read gif: {}", (Object)status);
                        }
                        break block14;
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null) {
                            this.processedImage = new ProcessedImageData(image);
                        }
                    }
                    catch (IOException e1) {
                        exception = e1;
                        LOGGER.error("Failed to parse BufferedImage from stream", (Throwable)e1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e) {
            exception = e;
            LOGGER.error("An exception occurred while loading OPFrame image", (Throwable)e);
        }
        if (this.processedImage == null) {
            this.error = exception == null ? "download.exception.gif" : (exception.getMessage().startsWith("Server returned HTTP response code: 403") ? "download.exception.forbidden" : (exception.getMessage().startsWith("Server returned HTTP response code: 404") ? "download.exception.notfound" : "download.exception.invalid"));
            TEXTURE_CACHE.deleteEntry(this.url);
        }
        this.complete = true;
        Object object = LOCK;
        synchronized (object) {
            loadingImages.remove(this.url);
            --activeDownloads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(String url) throws IOException {
        TextureCache.CacheEntry entry = TEXTURE_CACHE.getEntry(url);
        long requestTime = System.currentTimeMillis();
        URLConnection connection = new URL(url).openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:25.0) Gecko/20100101 Firefox/25.0");
        int responseCode = -1;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (entry != null) {
                if (entry.getEtag() != null) {
                    httpConnection.setRequestProperty("If-None-Match", entry.getEtag());
                } else if (entry.getTime() != -1L) {
                    httpConnection.setRequestProperty("If-Modified-Since", FORMAT.format(new Date(entry.getTime())));
                }
            }
            responseCode = httpConnection.getResponseCode();
        }
        InputStream in = null;
        try {
            long lastModifiedTimestamp;
            String lastModified;
            String expires;
            in = connection.getInputStream();
            String etag = connection.getHeaderField("ETag");
            long expireTimestamp = -1L;
            String maxAge = connection.getHeaderField("max-age");
            if (maxAge != null && !maxAge.isEmpty()) {
                try {
                    expireTimestamp = requestTime + Long.parseLong(maxAge) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((expires = connection.getHeaderField("Expires")) != null && !expires.isEmpty()) {
                try {
                    expireTimestamp = FORMAT.parse(expires).getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((lastModified = connection.getHeaderField("Last-Modified")) != null && !lastModified.isEmpty()) {
                try {
                    lastModifiedTimestamp = FORMAT.parse(lastModified).getTime();
                }
                catch (ParseException e) {
                    lastModifiedTimestamp = requestTime;
                }
            } else {
                lastModifiedTimestamp = requestTime;
            }
            if (entry != null) {
                File file;
                if (etag != null && !etag.isEmpty()) {
                    entry.setEtag(etag);
                }
                entry.setTime(lastModifiedTimestamp);
                if (responseCode == 304 && (file = entry.getFile()).exists()) {
                    byte[] byArray = IOUtils.toByteArray((InputStream)new FileInputStream(file));
                    return byArray;
                }
            }
            byte[] data = IOUtils.toByteArray((InputStream)in);
            TEXTURE_CACHE.save(url, etag, lastModifiedTimestamp, expireTimestamp, data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String readType(byte[] input) throws IOException {
        String string;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            string = DownloadThread.readType(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return "";
        }
        ImageReader reader = iter.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PictureTexture loadImage(DownloadThread thread) {
        PictureTexture texture = null;
        if (!thread.hasFailed()) {
            texture = thread.processedImage.isAnimated() ? new AnimatedPictureTexture(thread.processedImage) : new OrdinaryTexture(thread.processedImage);
        }
        if (texture != null) {
            Object object = LOCK;
            synchronized (object) {
                loadedImages.put(thread.url, texture);
            }
        }
        return texture;
    }
}

