/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WorldUtils {
    public static final EnumFacing[] FACES_AND_NULL = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public static void dropItem(World world, Vec3d pos, ItemStack stack) {
        if (!world.field_72995_K && !stack.func_190926_b()) {
            EntityItem ent = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
            ent.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
            ent.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
            ent.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
            ent.func_174869_p();
            world.func_72838_d((Entity)ent);
        }
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && !stack.func_190926_b()) {
            EntityItem ent = new EntityItem(world, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat() * 0.5f) + 0.25, (double)((float)pos.func_177956_o() + world.field_73012_v.nextFloat() * 0.5f) + 0.25, (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat() * 0.5f) + 0.25, stack);
            ent.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
            ent.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
            ent.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
            ent.func_174869_p();
            world.func_72838_d((Entity)ent);
        }
    }

    public static void dropItem(WorldBlockPos pos, ItemStack stack) {
        WorldUtils.dropItem(pos.getWorld(), pos.getPos(), stack);
    }

    public static void iterateAdjacentTiles(TileEntity tile, BiConsumer<TileEntity, EnumFacing> func) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity adj = WorldUtils.getAdjacentTile(tile, dir);
            if (adj == null) continue;
            func.accept(adj, dir);
        }
    }

    @Nullable
    public static TileEntity getAdjacentTile(TileEntity base, EnumFacing dir) {
        return base.func_145831_w().func_175625_s(base.func_174877_v().func_177971_a(dir.func_176730_m()));
    }

    public static Vec3d getBlockCenter(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static boolean pointLiesInBlock(Vec3d point, BlockPos block) {
        return point.field_72450_a >= (double)block.func_177958_n() && point.field_72450_a <= (double)(block.func_177958_n() + 1) && point.field_72448_b >= (double)block.func_177956_o() && point.field_72448_b <= (double)(block.func_177956_o() + 1) && point.field_72449_c >= (double)block.func_177952_p() && point.field_72449_c <= (double)(block.func_177952_p() + 1);
    }
}

