/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.util.render.TextureRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Loader;

public class RenderUtils {
    private static OptifineStatus optifined = OptifineStatus.CHECK_NEEDED;
    private static boolean lightmapCached = false;
    private static float cachedLightmapX;
    private static float cachedLightmapY;

    public static boolean checkOptifine() {
        if (optifined == OptifineStatus.CHECK_NEEDED) {
            OptifineStatus optifineStatus = optifined = Loader.isModLoaded((String)"optifine") ? OptifineStatus.PRESENT : OptifineStatus.NOT_PRESENT;
            if (optifined == OptifineStatus.PRESENT) {
                LibNine.LOGGER.warn("Whoops! You have Optifine installed. That might cause some weird rendering issues.");
            }
        }
        return optifined == OptifineStatus.PRESENT;
    }

    public static void setLightmapCoords(float x, float y) {
        if (RenderUtils.checkOptifine()) {
            return;
        }
        if (!lightmapCached) {
            RenderUtils.cacheLightmapCoords(OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    private static void cacheLightmapCoords(float x, float y) {
        cachedLightmapX = x;
        cachedLightmapY = y;
        GlStateManager.func_179140_f();
        lightmapCached = true;
    }

    public static void restoreLightmap() {
        if (RenderUtils.checkOptifine()) {
            return;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)cachedLightmapX, (float)cachedLightmapY);
        GlStateManager.func_179145_e();
        lightmapCached = false;
    }

    public static void enableFullBrightness() {
        RenderUtils.setLightmapCoords(240.0f, 240.0f);
    }

    public static Vec3d getInterpPos(Entity entity, float partialTicks) {
        return new Vec3d(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks, entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks, entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks);
    }

    public static void renderWorldOrtho(double x, double y, double z, float scaleX, float scaleY, float angle, float u1, float v1, float u2, float v2, float lookX, float lookXZ, float lookZ, float lookYZ, float lookXY) {
        Vec3d[] vertices = new Vec3d[]{new Vec3d((double)(-lookX * scaleX - lookYZ * scaleY), (double)(-lookXZ * scaleY), (double)(-lookZ * scaleX - lookXY * scaleY)), new Vec3d((double)(-lookX * scaleX + lookYZ * scaleY), (double)(lookXZ * scaleY), (double)(-lookZ * scaleX + lookXY * scaleY)), new Vec3d((double)(lookX * scaleX + lookYZ * scaleY), (double)(lookXZ * scaleY), (double)(lookZ * scaleX + lookXY * scaleY)), new Vec3d((double)(lookX * scaleX - lookYZ * scaleY), (double)(-lookXZ * scaleY), (double)(lookZ * scaleX - lookXY * scaleY))};
        float angX = MathHelper.func_76134_b((float)(angle * 0.5f));
        Vec3d axial = Minecraft.func_71410_x().field_71439_g.func_70040_Z().func_186678_a((double)MathHelper.func_76126_a((float)(angle * 0.5f)));
        for (int i = 0; i < 4; ++i) {
            vertices[i] = axial.func_186678_a(2.0 * vertices[i].func_72430_b(axial)).func_178787_e(vertices[i].func_186678_a((double)(angX * angX) - axial.func_72430_b(axial))).func_178787_e(axial.func_72431_c(vertices[i]).func_186678_a((double)(2.0f * angX)));
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x + vertices[0].field_72450_a, y + vertices[0].field_72448_b, z + vertices[0].field_72449_c).func_187315_a((double)u2, (double)v2).func_181675_d();
        buf.func_181662_b(x + vertices[1].field_72450_a, y + vertices[1].field_72448_b, z + vertices[1].field_72449_c).func_187315_a((double)u2, (double)v1).func_181675_d();
        buf.func_181662_b(x + vertices[2].field_72450_a, y + vertices[2].field_72448_b, z + vertices[2].field_72449_c).func_187315_a((double)u1, (double)v1).func_181675_d();
        buf.func_181662_b(x + vertices[3].field_72450_a, y + vertices[3].field_72448_b, z + vertices[3].field_72449_c).func_187315_a((double)u1, (double)v2).func_181675_d();
        tess.func_78381_a();
    }

    public static void renderWorldOrtho(double x, double y, double z, float scaleX, float scaleY, float angle, float lookX, float lookXZ, float lookZ, float lookYZ, float lookXY) {
        RenderUtils.renderWorldOrtho(x, y, z, scaleX, scaleY, angle, 0.0f, 0.0f, 1.0f, 1.0f, lookX, lookXZ, lookZ, lookYZ, lookXY);
    }

    public static void renderWorldOrtho(double x, double y, double z, float scaleX, float scaleY, float angle, float u1, float v1, float u2, float v2) {
        RenderUtils.renderWorldOrtho(x, y, z, scaleX, scaleY, angle, u1, v1, u2, v2, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178809_c(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f());
    }

    public static void renderWorldOrtho(double x, double y, double z, float scaleX, float scaleY, float angle, TextureRegion icon) {
        icon.getTexture().bind();
        RenderUtils.renderWorldOrtho(x, y, z, scaleX, scaleY, angle, icon.getU1(), icon.getV1(), icon.getU2(), icon.getV2());
    }

    public static void renderWorldOrtho(double x, double y, double z, float scaleX, float scaleY, float angle) {
        RenderUtils.renderWorldOrtho(x, y, z, scaleX, scaleY, angle, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void renderScreenOverlay(TextureRegion texture, ScaledResolution res) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        texture.draw(0, 0, res.func_78326_a(), res.func_78328_b());
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
    }

    private static enum OptifineStatus {
        CHECK_NEEDED,
        PRESENT,
        NOT_PRESENT;

    }
}

