/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.nbt;

import io.github.phantamanta44.libnine.util.math.Vec2i;
import io.github.phantamanta44.libnine.util.nbt.ChainingTagCompound;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.util.stream.Collector;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class NBTUtils {
    public static ChainingTagCompound serializeBlockPos(BlockPos pos) {
        return new ChainingTagCompound().withInt("x", pos.func_177958_n()).withInt("y", pos.func_177956_o()).withInt("z", pos.func_177952_p());
    }

    public static BlockPos deserializeBlockPos(NBTTagCompound tag) {
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static ChainingTagCompound serializeWorldBlockPos(WorldBlockPos pos) {
        return new ChainingTagCompound().withInt("dim", pos.getDimId()).withTag("pos", NBTUtils.serializeBlockPos(pos.getPos()));
    }

    public static WorldBlockPos deserializeWorldBlockPos(NBTTagCompound tag) {
        return new WorldBlockPos(tag.func_74762_e("dim"), NBTUtils.deserializeBlockPos(tag.func_74775_l("pos")));
    }

    public static ChainingTagCompound serializeVec3d(Vec3d vec) {
        return new ChainingTagCompound().withDouble("x", vec.field_72450_a).withDouble("y", vec.field_72448_b).withDouble("z", vec.field_72449_c);
    }

    public static Vec3d deserializeVec3d(NBTTagCompound tag) {
        return new Vec3d(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
    }

    public static ChainingTagCompound serializeVec2i(Vec2i vec) {
        return new ChainingTagCompound().withInt("x", vec.getX()).withInt("y", vec.getY());
    }

    public static Vec2i deserializeVec2i(NBTTagCompound tag) {
        return new Vec2i(tag.func_74762_e("x"), tag.func_74762_e("y"));
    }

    public static <T extends NBTBase> Collector<T, NBTTagList, NBTTagList> collectList() {
        return Collector.of(NBTTagList::new, NBTTagList::func_74742_a, NBTUtils::mergeLists, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static NBTTagList mergeLists(NBTTagList a, NBTTagList b) {
        NBTTagList result = new NBTTagList();
        for (NBTBase tag : a) {
            result.func_74742_a(tag);
        }
        for (NBTBase tag : b) {
            result.func_74742_a(tag);
        }
        return result;
    }
}

