/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public static Stream<ItemStack> stream(IInventory inv) {
        return IntStream.range(0, inv.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inv).func_70301_a(arg_0));
    }

    public static Stream<ItemStack> stream(IItemHandler inv) {
        return IntStream.range(0, inv.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inv).getStackInSlot(arg_0));
    }

    public static Stream<ItemStack> streamInventory(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return InventoryUtils.stream((IInventory)((EntityPlayer)entity).field_71071_by);
        }
        return OptUtils.capability((ICapabilityProvider)entity, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(InventoryUtils::stream).orElseGet(() -> StreamSupport.stream(entity.func_184209_aF().spliterator(), false));
    }

    public static void accrue(Accrue<ItemStack> accum, IItemHandler ... invs) {
        for (IItemHandler inv : invs) {
            InventoryUtils.stream(inv).forEach(accum);
        }
    }

    public static IItemHandlerModifiable insertOnly(IItemHandlerModifiable delegate) {
        return new InsertOnlyItemHandler(delegate);
    }

    public static IItemHandlerModifiable extractOnly(IItemHandlerModifiable delegate) {
        return new ExtractOnlyItemHandler(delegate);
    }

    private static class ExtractOnlyItemHandler
    implements IItemHandlerModifiable {
        private final IItemHandlerModifiable delegate;

        ExtractOnlyItemHandler(IItemHandlerModifiable delegate) {
            this.delegate = delegate;
        }

        public int getSlots() {
            return this.delegate.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.delegate.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.delegate.setStackInSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.delegate.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.delegate.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    private static class InsertOnlyItemHandler
    implements IItemHandlerModifiable {
        private final IItemHandlerModifiable delegate;

        InsertOnlyItemHandler(IItemHandlerModifiable delegate) {
            this.delegate = delegate;
        }

        public int getSlots() {
            return this.delegate.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.delegate.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.delegate.setStackInSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.delegate.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.delegate.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.delegate.isItemValid(slot, stack);
        }
    }
}

