/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;

public class InputUtils {
    public static String getKeybindKeyName(KeyBinding binding) {
        return Keyboard.getKeyName((int)binding.func_151463_i());
    }

    public static boolean checkModsNonExclusive(ModKey ... mods) {
        for (ModKey mod : mods) {
            if (mod.isActive()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkModsExclusive(ModKey ... mods) {
        return ModKey.calculateMask(mods) == ModKey.getMask();
    }

    public static enum ModKey {
        CTRL(29, 157),
        SHIFT(42, 54),
        ALT(56, 184);

        private final int[] codes;

        private ModKey(int ... codes) {
            this.codes = codes;
        }

        public boolean isActive() {
            for (int code : this.codes) {
                if (!Keyboard.isKeyDown((int)code)) continue;
                return true;
            }
            return false;
        }

        public static int getMask() {
            int mask = 0;
            for (ModKey mod : ModKey.values()) {
                if (!mod.isActive()) continue;
                mask |= 1 << mod.ordinal();
            }
            return mask;
        }

        public static int calculateMask(ModKey ... mods) {
            int mask = 0;
            for (ModKey mod : mods) {
                mask |= 1 << mod.ordinal();
            }
            return mask;
        }
    }
}

