/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.format;

import io.github.phantamanta44.libnine.util.format.TabulatedStringBuffer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class FormatUtils {
    private static final String[] SI_PREFIXES = new String[]{null, "k", "M", "G", "T", "P", "E"};
    private static final String[] SI_PREFIXES_FP = new String[]{"n", "\u03bc", "m", "", "k", "M", "G", "T", "P", "E"};

    public static String formatSI(int num, String unit) {
        if (num == 0) {
            return "0 " + unit;
        }
        int magnitude = (int)Math.floor(Math.log10(Math.abs(num)) / 3.0);
        if (magnitude == 0) {
            return num + " " + unit;
        }
        return String.format("%.2f %s%s", (double)num / Math.pow(10.0, magnitude * 3), SI_PREFIXES[magnitude], unit);
    }

    public static String formatSI(long num, String unit) {
        if (num == 0L) {
            return "0 " + unit;
        }
        int magnitude = (int)Math.floor(Math.log10(Math.abs(num)) / 3.0);
        if (magnitude == 0) {
            return num + " " + unit;
        }
        return String.format("%.2f %s%s", (double)num / Math.pow(10.0, magnitude * 3), SI_PREFIXES[magnitude], unit);
    }

    public static String formatSI(double num, String unit) {
        if (num == 0.0) {
            return "0 " + unit;
        }
        double val = num * 1.0E9;
        int magnitude = (int)Math.floor(Math.log10(Math.abs(val)) / 3.0);
        return String.format("%.2f %s%s", val / Math.pow(10.0, magnitude * 3), SI_PREFIXES_FP[magnitude], unit);
    }

    public static String formatPercentage(float percent) {
        return String.format("%.1f%%", Float.valueOf(percent * 100.0f));
    }

    public static String formatPercentage(double percent) {
        return String.format("%.1f%%", percent * 100.0);
    }

    public static String formatClassName(Class<?> clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1).replace('$', '_');
    }

    public static String toTitleCase(String a) {
        return a.substring(0, 1).toUpperCase() + a.substring(1);
    }

    public static String formatNbt(NBTBase tag) {
        TabulatedStringBuffer buf = new TabulatedStringBuffer();
        FormatUtils.formatNbt(buf, tag);
        return buf.toString();
    }

    public static void formatNbt(TabulatedStringBuffer buf, NBTBase tag) {
        switch (tag.func_74732_a()) {
            case 1: {
                buf.append(String.format("%2xb", ((NBTTagByte)tag).func_150290_f()));
                break;
            }
            case 2: {
                buf.append(((NBTTagShort)tag).func_150289_e() + "s");
                break;
            }
            case 3: {
                buf.append(((NBTTagInt)tag).func_150287_d() + "i");
                break;
            }
            case 4: {
                buf.append(((NBTTagLong)tag).func_150291_c() + "j");
                break;
            }
            case 5: {
                buf.append(String.format("%.4ff", Float.valueOf(((NBTTagFloat)tag).func_150288_h())));
                break;
            }
            case 6: {
                buf.append(String.format("%.4fd", ((NBTTagDouble)tag).func_150286_g()));
                break;
            }
            case 7: {
                buf.append("[");
                for (byte n : ((NBTTagByteArray)tag).func_150292_c()) {
                    buf.append(String.format("%2xb", n));
                }
                buf.append("]");
                break;
            }
            case 11: {
                buf.append("[");
                for (int n : ((NBTTagIntArray)tag).func_150302_c()) {
                    buf.append(n + "i");
                }
                buf.append("]");
                break;
            }
            case 12: {
                buf.append(tag.toString());
                break;
            }
            case 8: {
                buf.append(((NBTTagString)tag).func_150285_a_());
                break;
            }
            case 9: {
                buf.append("[").indent();
                ((NBTTagList)tag).forEach(subTag -> {
                    buf.newLine();
                    FormatUtils.formatNbt(buf, subTag);
                });
                buf.outdent().appendLine("]");
                break;
            }
            case 10: {
                buf.append("{").indent();
                NBTTagCompound compound = (NBTTagCompound)tag;
                compound.func_150296_c().forEach(key -> {
                    buf.appendLine((String)key).append(": ");
                    FormatUtils.formatNbt(buf, compound.func_74781_a(key));
                });
                buf.outdent().appendLine("}");
            }
        }
    }
}

