/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.data.serialization;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.util.LazyConstant;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.data.serialization.IDatum;
import io.github.phantamanta44.libnine.util.data.serialization.ISerializationProvider;
import io.github.phantamanta44.libnine.util.data.serialization.LambdaSerializer;
import io.github.phantamanta44.libnine.util.format.FormatUtils;
import io.github.phantamanta44.libnine.util.helper.MirrorUtils;
import io.github.phantamanta44.libnine.util.math.Vec2i;
import io.github.phantamanta44.libnine.util.nbt.NBTUtils;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DataSerialization {
    private static final Collection<ISerializationProvider<?>> DEFAULT_SERIALIZATION_PROVIDERS = Arrays.asList(new LambdaSerializer<Integer>(Integer.class, NBTTagCompound::func_74768_a, NBTTagCompound::func_74762_e, ByteUtils.Writer::writeInt, ByteUtils.Reader::readInt), new LambdaSerializer<Float>(Float.class, NBTTagCompound::func_74776_a, NBTTagCompound::func_74760_g, ByteUtils.Writer::writeFloat, ByteUtils.Reader::readFloat), new LambdaSerializer<Double>(Double.class, NBTTagCompound::func_74780_a, NBTTagCompound::func_74769_h, ByteUtils.Writer::writeDouble, ByteUtils.Reader::readDouble), new LambdaSerializer<Byte>(Byte.class, NBTTagCompound::func_74774_a, NBTTagCompound::func_74771_c, ByteUtils.Writer::writeByte, ByteUtils.Reader::readByte), new LambdaSerializer<Short>(Short.class, NBTTagCompound::func_74777_a, NBTTagCompound::func_74765_d, ByteUtils.Writer::writeShort, ByteUtils.Reader::readShort), new LambdaSerializer<Long>(Long.class, NBTTagCompound::func_74772_a, NBTTagCompound::func_74763_f, ByteUtils.Writer::writeLong, ByteUtils.Reader::readLong), new LambdaSerializer<Boolean>(Boolean.class, NBTTagCompound::func_74757_a, NBTTagCompound::func_74767_n, ByteUtils.Writer::writeBool, ByteUtils.Reader::readBool), new LambdaSerializer<String>(String.class, NBTTagCompound::func_74778_a, NBTTagCompound::func_74779_i, ByteUtils.Writer::writeString, ByteUtils.Reader::readString), new LambdaSerializer<NBTTagCompound>(NBTTagCompound.class, NBTTagCompound::func_74782_a, NBTTagCompound::func_74775_l, ByteUtils.Writer::writeTagCompound, ByteUtils.Reader::readTagCompound), new LambdaSerializer<ItemStack>(ItemStack.class, (t, k, s) -> {
        NBTTagCompound i = new NBTTagCompound();
        s.func_77955_b(i);
        t.func_74782_a(k, (NBTBase)i);
    }, (t, k) -> new ItemStack(t.func_74775_l(k)), ByteUtils.Writer::writeItemStack, ByteUtils.Reader::readItemStack), new LambdaSerializer<Fluid>(Fluid.class, (t, k, f) -> t.func_74778_a(k, f.getName()), (t, k) -> FluidRegistry.getFluid((String)t.func_74779_i(k)), ByteUtils.Writer::writeFluid, ByteUtils.Reader::readFluid), new LambdaSerializer<FluidStack>(FluidStack.class, (t, k, s) -> {
        NBTTagCompound f = new NBTTagCompound();
        s.writeToNBT(f);
        t.func_74782_a(k, (NBTBase)f);
    }, (t, k) -> FluidStack.loadFluidStackFromNBT((NBTTagCompound)t.func_74775_l(k)), ByteUtils.Writer::writeFluidStack, ByteUtils.Reader::readFluidStack), new LambdaSerializer<BlockPos>(BlockPos.class, (t, k, p) -> t.func_74782_a(k, (NBTBase)NBTUtils.serializeBlockPos(p)), (t, k) -> NBTUtils.deserializeBlockPos(t.func_74775_l(k)), ByteUtils.Writer::writeBlockPos, ByteUtils.Reader::readBlockPos), new LambdaSerializer<WorldBlockPos>(WorldBlockPos.class, (t, k, p) -> t.func_74782_a(k, (NBTBase)NBTUtils.serializeWorldBlockPos(p)), (t, k) -> NBTUtils.deserializeWorldBlockPos(t.func_74775_l(k)), ByteUtils.Writer::writeWorldBlockPos, ByteUtils.Reader::readWorldBlockPos), new LambdaSerializer<Vec3d>(Vec3d.class, (t, k, v) -> t.func_74782_a(k, (NBTBase)NBTUtils.serializeVec3d(v)), (t, k) -> NBTUtils.deserializeVec3d(t.func_74775_l(k)), ByteUtils.Writer::writeVec3d, ByteUtils.Reader::readVec3d), new LambdaSerializer<Vec2i>(Vec2i.class, (t, k, v) -> t.func_74782_a(k, (NBTBase)NBTUtils.serializeVec2i(v)), (t, k) -> NBTUtils.deserializeVec2i(t.func_74775_l(k)), ByteUtils.Writer::writeVec2i, ByteUtils.Reader::readVec2i), new LambdaSerializer<UUID>(UUID.class, (t, k, i) -> t.func_74778_a(k, i.toString()), (t, k) -> UUID.fromString(t.func_74779_i(k)), ByteUtils.Writer::writeUuid, ByteUtils.Reader::readUuid));
    private static final Map<Class<?>, List<Field>> classMappings = new IdentityHashMap();
    private final Object target;
    private final Map<Class<?>, ISerializationProvider<?>> serializers;
    private final List<Supplier<DataProperty>> properties;

    private static List<Field> getOrComputeClassMappings(Class<?> src) {
        List<Field> mappings = classMappings.get(src);
        if (mappings == null) {
            LibNine.LOGGER.info("Calculating serialization mappings for class: {}", (Object)src.getName());
            mappings = MirrorUtils.getHierarchy(src).stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(f -> f.isAnnotationPresent(AutoSerialize.class)).sorted(Comparator.comparing(Field::getName)).peek(f -> f.setAccessible(true)).collect(Collectors.toList());
            classMappings.put(src, mappings);
        }
        return mappings;
    }

    public DataSerialization(Object target, Collection<ISerializationProvider<?>> serializationProviders) {
        this.target = target;
        this.serializers = new IdentityHashMap();
        for (ISerializationProvider<?> provider : serializationProviders) {
            this.serializers.put(provider.getSerializationType(), provider);
        }
        this.properties = DataSerialization.getOrComputeClassMappings(target.getClass()).stream().map(f -> new LazyConstant<DataProperty>(() -> {
            Class<?> type = f.getType();
            if (IDatum.class.isAssignableFrom(type)) {
                try {
                    return new DataPropertyDatum(f.getAnnotation(AutoSerialize.class), f.getName(), (IDatum)f.get(target));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not read field: " + f.toString(), e);
                }
            }
            if (ISerializable.class.isAssignableFrom(type)) {
                try {
                    return new DataPropertySerializable(f.getAnnotation(AutoSerialize.class), f.getName(), (ISerializable)f.get(target));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not read field: " + f.toString(), e);
                }
            }
            return new DataPropertyMutableField(f.getAnnotation(AutoSerialize.class), f.getName(), (Field)f);
        })).collect(Collectors.toList());
    }

    public DataSerialization(Object target) {
        this(target, DEFAULT_SERIALIZATION_PROVIDERS);
    }

    private Stream<DataProperty> resolveProperties() {
        return this.properties.stream().map(Supplier::get);
    }

    public void serializeNBT(NBTTagCompound tag) {
        this.resolveProperties().forEach(prop -> prop.serializeNBT(tag));
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.resolveProperties().forEach(prop -> prop.deserializeNBT(tag));
    }

    public void serializeBytes(ByteUtils.Writer data) {
        this.serializeBytes(data, true);
    }

    public void serializeBytes(ByteUtils.Writer data, boolean sync) {
        Stream<DataProperty> props = this.resolveProperties();
        (sync ? props.filter(prop -> prop.sync) : props).forEach(prop -> prop.serializeBytes(data));
    }

    public void deserializeBytes(ByteUtils.Reader data) {
        this.deserializeBytes(data, true);
    }

    public void deserializeBytes(ByteUtils.Reader data, boolean sync) {
        Stream<DataProperty> props = this.resolveProperties();
        (sync ? props.filter(prop -> prop.sync) : props).forEach(prop -> prop.deserializeBytes(data));
    }

    private <T> ISerializationProvider<T> getSerializationProvider(Class<T> clazz) {
        ISerializationProvider<?> serializer = this.serializers.get(clazz);
        if (serializer == null) {
            throw new UnsupportedOperationException("No serializer for type: " + clazz.getName());
        }
        return serializer;
    }

    private class DataPropertyMutableField<T>
    extends DataProperty {
        private final Field field;
        private final Class<T> dataClass;

        DataPropertyMutableField(AutoSerialize annot, String fallbackName, Field field) {
            super(annot, fallbackName);
            this.field = field;
            this.dataClass = field.getType();
        }

        private T fieldGet() {
            try {
                return (T)this.field.get(DataSerialization.this.target);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not read field: " + this.field.toString(), e);
            }
        }

        private void fieldSet(T value) {
            try {
                this.field.set(DataSerialization.this.target, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not write field: " + this.field.toString(), e);
            }
        }

        @Override
        void serializeNBT(NBTTagCompound tag) {
            if (this.dataClass.isEnum()) {
                tag.func_74777_a(this.key, (short)((Enum)this.fieldGet()).ordinal());
            } else {
                DataSerialization.this.getSerializationProvider(this.dataClass).serializeNBT(this.fieldGet(), this.key, tag);
            }
        }

        @Override
        void deserializeNBT(NBTTagCompound tag) {
            if (this.dataClass.isEnum()) {
                this.fieldSet(this.dataClass.getEnumConstants()[tag.func_74765_d(this.key)]);
            } else {
                this.fieldSet(DataSerialization.this.getSerializationProvider(this.dataClass).deserializeNBT(this.key, tag));
            }
        }

        @Override
        void serializeBytes(ByteUtils.Writer data) {
            if (this.dataClass.isEnum()) {
                data.writeShort((short)((Enum)this.fieldGet()).ordinal());
            } else {
                DataSerialization.this.getSerializationProvider(this.dataClass).serializeBytes(this.fieldGet(), data);
            }
        }

        @Override
        void deserializeBytes(ByteUtils.Reader data) {
            if (this.dataClass.isEnum()) {
                this.fieldSet(this.dataClass.getEnumConstants()[data.readShort()]);
            } else {
                this.fieldSet(DataSerialization.this.getSerializationProvider(this.dataClass).deserializeBytes(data));
            }
        }
    }

    private class DataPropertyDatum<T>
    extends DataProperty {
        private final IDatum<T> datum;
        @Nullable
        private Class<T> dataClass;

        DataPropertyDatum(AutoSerialize annot, String fallbackName, IDatum<T> datum) {
            super(annot, fallbackName);
            this.dataClass = null;
            this.datum = datum;
        }

        private Class<T> getDataClass() {
            if (this.dataClass == null) {
                this.dataClass = this.datum.get().getClass();
            }
            return this.dataClass;
        }

        @Override
        public void serializeNBT(NBTTagCompound tag) {
            if (this.getDataClass().isEnum()) {
                tag.func_74777_a(this.key, (short)((Enum)this.datum.get()).ordinal());
            } else {
                DataSerialization.this.getSerializationProvider(this.getDataClass()).serializeNBT(this.datum.get(), this.key, tag);
            }
        }

        @Override
        public void deserializeNBT(NBTTagCompound tag) {
            if (this.getDataClass().isEnum()) {
                this.datum.set(this.getDataClass().getEnumConstants()[tag.func_74765_d(this.key)]);
            } else {
                this.datum.set(DataSerialization.this.getSerializationProvider(this.getDataClass()).deserializeNBT(this.key, tag));
            }
        }

        @Override
        public void serializeBytes(ByteUtils.Writer data) {
            if (this.getDataClass().isEnum()) {
                data.writeShort((short)((Enum)this.datum.get()).ordinal());
            } else {
                DataSerialization.this.getSerializationProvider(this.getDataClass()).serializeBytes(this.datum.get(), data);
            }
        }

        @Override
        public void deserializeBytes(ByteUtils.Reader data) {
            if (this.getDataClass().isEnum()) {
                this.datum.set(this.getDataClass().getEnumConstants()[data.readShort()]);
            } else {
                this.datum.set(DataSerialization.this.getSerializationProvider(this.getDataClass()).deserializeBytes(data));
            }
        }
    }

    private static class DataPropertySerializable
    extends DataProperty {
        private final ISerializable datum;

        DataPropertySerializable(AutoSerialize annot, String fallbackName, ISerializable datum) {
            super(annot, fallbackName);
            this.datum = datum;
        }

        @Override
        public void serializeNBT(NBTTagCompound tag) {
            NBTTagCompound serTag = new NBTTagCompound();
            this.datum.serNBT(serTag);
            tag.func_74782_a(this.key, (NBTBase)serTag);
        }

        @Override
        public void deserializeNBT(NBTTagCompound tag) {
            this.datum.deserNBT(tag.func_74775_l(this.key));
        }

        @Override
        public void serializeBytes(ByteUtils.Writer data) {
            this.datum.serBytes(data);
        }

        @Override
        public void deserializeBytes(ByteUtils.Reader data) {
            this.datum.deserBytes(data);
        }
    }

    private static abstract class DataProperty {
        final String key;
        final boolean sync;

        DataProperty(AutoSerialize annot, String fallbackName) {
            String name = annot.value();
            this.key = FormatUtils.toTitleCase(name.isEmpty() ? fallbackName : name);
            this.sync = annot.sync();
        }

        abstract void serializeNBT(NBTTagCompound var1);

        abstract void deserializeNBT(NBTTagCompound var1);

        abstract void serializeBytes(ByteUtils.Writer var1);

        abstract void deserializeBytes(ByteUtils.Reader var1);
    }
}

