/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface IDisplayableMatcher<T>
extends Predicate<T> {
    public List<T> getVisuals();

    default public T getVisual() {
        return this.getVisuals().get(0);
    }

    public static <T> IDisplayableMatcher<T> ofMany(final Supplier<List<T>> display, final Predicate<T> matcher) {
        return new IDisplayableMatcher<T>(){

            @Override
            public List<T> getVisuals() {
                return (List)display.get();
            }

            @Override
            public boolean test(T t) {
                return matcher.test(t);
            }
        };
    }

    public static <T> IDisplayableMatcher<T> of(Supplier<T> display, Predicate<T> matcher) {
        return IDisplayableMatcher.ofMany(() -> Collections.singletonList(display.get()), matcher);
    }
}

