/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.gui;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.github.phantamanta44.libnine.Virtue;
import io.github.phantamanta44.libnine.gui.GuiIdentity;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class L9GuiHandler
implements IGuiHandler {
    private final Virtue virtue;
    private final TObjectIntMap<GuiIdentity> guiIdentityMappings;
    private final TIntObjectMap<IContainerFactory> serverGuiMappings;
    private final TIntObjectMap<IGuiFactory> clientGuiMappings;
    private int currentIndex;

    public L9GuiHandler(Virtue virtue) {
        this.virtue = virtue;
        this.guiIdentityMappings = new TObjectIntHashMap();
        this.serverGuiMappings = new TIntObjectHashMap();
        this.clientGuiMappings = new TIntObjectHashMap();
        this.currentIndex = -1;
    }

    private int indexFor(GuiIdentity identity) {
        if (!this.guiIdentityMappings.containsKey((Object)identity)) {
            this.guiIdentityMappings.put((Object)identity, ++this.currentIndex);
            return this.currentIndex;
        }
        return this.guiIdentityMappings.get((Object)identity);
    }

    public <T extends Container> void registerServerGui(GuiIdentity<T, ?> identity, IContainerFactory<T> factory) {
        this.serverGuiMappings.put(this.indexFor(identity), factory);
    }

    public <S extends Container, C> void registerClientGui(GuiIdentity<S, C> identity, IGuiFactory<S, C> factory) {
        this.clientGuiMappings.put(this.indexFor(identity), factory);
    }

    public int getGuiId(GuiIdentity<?, ?> identity) {
        return this.guiIdentityMappings.get(identity);
    }

    public void openGui(EntityPlayer player, GuiIdentity<?, ?> identity, WorldBlockPos pos) {
        player.openGui((Object)this.virtue, this.getGuiId(identity), pos.getWorld(), pos.getX(), pos.getY(), pos.getZ());
    }

    @Nullable
    public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return ((IContainerFactory)this.serverGuiMappings.get(id)).create(player, world, x, y, z);
    }

    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return ((IGuiFactory)this.clientGuiMappings.get(id)).create(((IContainerFactory)this.serverGuiMappings.get(id)).create(player, world, x, y, z), player, world, x, y, z);
    }

    @FunctionalInterface
    public static interface IGuiFactory<S extends Container, C> {
        public C create(S var1, EntityPlayer var2, World var3, int var4, int var5, int var6);
    }

    @FunctionalInterface
    public static interface IContainerFactory<T extends Container> {
        public T create(EntityPlayer var1, World var2, int var3, int var4, int var5);
    }
}

