/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine;

import io.github.phantamanta44.libnine.InitMe;
import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.Registrar;
import io.github.phantamanta44.libnine.Virtue;
import io.github.phantamanta44.libnine.event.TileEntityDispatchHandler;
import io.github.phantamanta44.libnine.network.PacketServerSyncTileEntity;
import io.github.phantamanta44.libnine.recipe.IRecipeList;
import io.github.phantamanta44.libnine.recipe.IRecipeManager;
import io.github.phantamanta44.libnine.recipe.RecipeManager;
import io.github.phantamanta44.libnine.recipe.type.SmeltingRecipe;
import io.github.phantamanta44.libnine.tile.L9TileEntity;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class L9CommonProxy {
    private final Registrar registrar;
    private final RecipeManager recipeManager;
    private final TileEntityDispatchHandler teDispatcher = new TileEntityDispatchHandler();

    public L9CommonProxy() {
        this.registrar = this.initRegistrar();
        this.recipeManager = this.initRecipeManager();
    }

    protected Registrar initRegistrar() {
        return new Registrar();
    }

    protected RecipeManager initRecipeManager() {
        return new RecipeManager();
    }

    public Registrar getRegistrar() {
        return this.registrar;
    }

    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public TileEntityDispatchHandler getTileEntityDispatcher() {
        return this.teDispatcher;
    }

    public void dispatchTileUpdate(L9TileEntity tile) {
        BlockPos pos = tile.func_174877_v();
        this.getRegistrar().lookUpTileVirtue(tile.getClass()).getNetworkHandler().sendToAllAround((IMessage)new PacketServerSyncTileEntity(tile), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }

    public World getAnySidedWorld() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
    }

    @Nullable
    public World getDimensionWorld(int dim) {
        return DimensionManager.getWorld((int)dim);
    }

    public World getDimensionWorldStrict(int dim) {
        World world = this.getDimensionWorld(dim);
        if (world == null) {
            throw new IllegalStateException("Nonexistent dimension: " + dim);
        }
        return world;
    }

    protected void onPreInit(FMLPreInitializationEvent event) {
        this.registrar.hookEvents();
        MinecraftForge.EVENT_BUS.register((Object)this.teDispatcher);
        block2: for (ASMDataTable.ASMData target : event.getAsmData().getAll(RegisterTile.class.getName())) {
            List deps = (List)target.getAnnotationInfo().get("deps");
            if (deps != null) {
                for (String dep : deps) {
                    if (Loader.isModLoaded((String)dep)) continue;
                    continue block2;
                }
            }
            this.getRegistrar().queueTileEntityReg((String)target.getAnnotationInfo().get("value"), target.getClassName());
        }
        Side actualSide = FMLCommonHandler.instance().getSide();
        for (ASMDataTable.ASMData target : event.getAsmData().getAll(InitMe.class.getName())) {
            boolean bind;
            List sides = (List)target.getAnnotationInfo().get("sides");
            boolean shouldContinue = true;
            if (sides != null) {
                shouldContinue = false;
                for (Object side : sides) {
                    if (actualSide != Side.valueOf((String)((ModAnnotation.EnumHolder)side).getValue())) continue;
                    shouldContinue = true;
                }
            }
            if (!shouldContinue) continue;
            String modId = (String)target.getAnnotationInfo().get("value");
            boolean bl = bind = modId != null && !modId.isEmpty();
            if (bind) {
                this.getRegistrar().begin(Virtue.forMod(modId));
            }
            try {
                String methodName = target.getObjectName();
                methodName = methodName.substring(0, methodName.lastIndexOf(40));
                Class.forName(target.getClassName()).getDeclaredMethod(methodName, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LibNine.LOGGER.error("Failed to run initializer {}::{} for virtue {}", (Object)target.getClassName(), (Object)target.getObjectName(), (Object)modId);
                LibNine.LOGGER.error("", (Throwable)e);
            }
            if (!bind) continue;
            this.getRegistrar().end();
        }
    }

    protected void onInit(FMLInitializationEvent event) {
    }

    protected void onPostInit(FMLPostInitializationEvent event) {
    }

    protected void onLoadComplete(FMLLoadCompleteEvent event) {
        IRecipeList smeltingRecipes = this.recipeManager.getRecipeList(SmeltingRecipe.class);
        FurnaceRecipes.func_77602_a().func_77599_b().forEach((i, o) -> smeltingRecipes.add(new SmeltingRecipe((ItemStack)i, (ItemStack)o)));
    }
}

