/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import tcb.spiderstpo.common.entity.mob.AbstractClimberEntity;

public class ClimberLookController
extends EntityLookHelper {
    private final AbstractClimberEntity entity;
    private float deltaLookYaw;
    private float deltaLookPitch;
    private boolean isLooking;
    private double posX;
    private double posY;
    private double posZ;

    public ClimberLookController(AbstractClimberEntity entity) {
        super((EntityLiving)entity);
        this.entity = entity;
    }

    public void func_75651_a(Entity entityIn, float deltaYaw, float deltaPitch) {
        this.posX = entityIn.field_70165_t;
        this.posY = entityIn instanceof EntityLivingBase ? entityIn.field_70163_u + (double)entityIn.func_70047_e() : (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0;
        this.posZ = entityIn.field_70161_v;
        this.deltaLookYaw = deltaYaw;
        this.deltaLookPitch = deltaPitch;
        this.isLooking = true;
    }

    public void func_75650_a(double x, double y, double z, float deltaYaw, float deltaPitch) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.deltaLookYaw = deltaYaw;
        this.deltaLookPitch = deltaPitch;
        this.isLooking = true;
    }

    public void func_75649_a() {
        this.entity.field_70125_A = 0.0f;
        if (this.isLooking) {
            this.isLooking = false;
            Vec3d dir = new Vec3d(this.posX - this.entity.field_70165_t, this.posY - this.entity.field_70163_u - (double)this.entity.func_70047_e(), this.posZ - this.entity.field_70161_v);
            Pair<Float, Float> rotation = this.entity.getOrientation(1.0f).getRotation(dir);
            this.entity.field_70125_A = this.updateRotation(this.entity.field_70125_A, ((Float)rotation.getRight()).floatValue(), this.deltaLookPitch);
            this.entity.field_70759_as = this.updateRotation(this.entity.field_70759_as, ((Float)rotation.getLeft()).floatValue(), this.deltaLookYaw);
        } else {
            this.entity.field_70759_as = this.updateRotation(this.entity.field_70759_as, this.entity.field_70761_aq, 10.0f);
        }
        float yawOffset = MathHelper.func_76142_g((float)(this.entity.field_70759_as - this.entity.field_70761_aq));
        if (!this.entity.func_70661_as().func_75500_f()) {
            if (yawOffset < -75.0f) {
                this.entity.field_70759_as = this.entity.field_70761_aq - 75.0f;
            }
            if (yawOffset > 75.0f) {
                this.entity.field_70759_as = this.entity.field_70761_aq + 75.0f;
            }
        }
    }

    private float updateRotation(float rotation, float target, float maxIncrement) {
        float increment = MathHelper.func_76142_g((float)(target - rotation));
        if (increment > maxIncrement) {
            increment = maxIncrement;
        }
        if (increment < -maxIncrement) {
            increment = -maxIncrement;
        }
        return rotation + increment;
    }

    public boolean func_180424_b() {
        return this.isLooking;
    }

    public double func_180423_e() {
        return this.posX;
    }

    public double func_180422_f() {
        return this.posY;
    }

    public double func_180421_g() {
        return this.posZ;
    }
}

