/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public class AdvancedWalkNodeProcessor<T extends EntityLiving>
extends WalkNodeProcessor {
    protected T obstructionAwareEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<EnumFacing> pathableFacings = EnumSet.of(EnumFacing.DOWN);
    private final Long2ObjectMap<PathNodeType> pathNodeTypeCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> aabbCollisionCache = new Object2BooleanOpenHashMap();
    protected boolean alwaysAllowDiagonals = true;

    public void setObstructionAwareEntity(T obstructionAwareEntity) {
        this.obstructionAwareEntity = obstructionAwareEntity;
    }

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(EnumFacing.NORTH);
            this.pathableFacings.add(EnumFacing.EAST);
            this.pathableFacings.add(EnumFacing.SOUTH);
            this.pathableFacings.add(EnumFacing.WEST);
        } else {
            this.pathableFacings.remove(EnumFacing.NORTH);
            this.pathableFacings.remove(EnumFacing.EAST);
            this.pathableFacings.remove(EnumFacing.SOUTH);
            this.pathableFacings.remove(EnumFacing.WEST);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(EnumFacing.UP);
        } else {
            this.pathableFacings.remove(EnumFacing.UP);
        }
    }

    public void func_186315_a(IBlockAccess sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.pathingSizeOffsetX = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70130_N / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70131_O + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70130_N / 2.0f + 1.0f)));
    }

    public void func_176163_a() {
        super.func_176163_a();
        this.pathNodeTypeCache.clear();
        this.aabbCollisionCache.clear();
    }

    private boolean checkAabbCollision(AxisAlignedBB aabb) {
        return (Boolean)this.aabbCollisionCache.computeIfAbsent((Object)aabb, p_237237_2_ -> this.field_186326_b.field_70170_p.func_184143_b(aabb));
    }

    public PathPoint func_186318_b() {
        BlockPos pos;
        double x = this.field_186326_b.field_70165_t;
        double y = this.field_186326_b.field_70163_u;
        double z = this.field_186326_b.field_70161_v;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int by = MathHelper.func_76128_c((double)y);
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            by = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), by, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p(pos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                pos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++by, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p(pos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E || !this.startFromGround) {
            by = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            pos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(pos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(pos).func_177230_c().func_176205_b(this.field_176169_a, pos)) && pos.func_177956_o() > 0) {
                pos = pos.func_177977_b();
            }
            by = pos.func_177984_a().func_177956_o();
        }
        BlockPos startPos = new BlockPos(x, y, z);
        PathNodeType startNodeType = this.getPathNodeTypeCached(this.field_186326_b, startPos.func_177958_n(), by, startPos.func_177952_p());
        if (this.field_186326_b.func_184643_a(startNodeType) < 0.0f) {
            AxisAlignedBB aabb = this.field_186326_b.func_174813_aQ();
            if (this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72340_a, (double)by, aabb.field_72339_c)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72340_a, (double)by, aabb.field_72334_f)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72336_d, (double)by, aabb.field_72339_c)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72336_d, (double)by, aabb.field_72334_f))) {
                PathPoint startPathPoint = this.func_176159_a(checkPos.func_177958_n(), checkPos.func_177956_o(), checkPos.func_177952_p());
                startPathPoint.field_186287_m = this.getPathNodeTypeCached(this.field_186326_b, new BlockPos(startPathPoint.field_75839_a, startPathPoint.field_75837_b, startPathPoint.field_75838_c));
                startPathPoint.field_186286_l = this.field_186326_b.func_184643_a(startPathPoint.field_186287_m);
                return startPathPoint;
            }
        }
        PathPoint startPathPoint = this.func_176159_a(startPos.func_177958_n(), by, startPos.func_177952_p());
        startPathPoint.field_186287_m = this.getPathNodeTypeCached(this.field_186326_b, new BlockPos(startPathPoint.field_75839_a, startPathPoint.field_75837_b, startPathPoint.field_75838_c));
        startPathPoint.field_186286_l = this.field_186326_b.func_184643_a(startPathPoint.field_186287_m);
        return startPathPoint;
    }

    private boolean isSafeStartingPosition(BlockPos pos) {
        PathNodeType pathnodetype = this.getPathNodeTypeCached(this.field_186326_b, pos);
        return this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f;
    }

    private boolean allowDiagonalPathOptions(PathPoint[] options) {
        return this.alwaysAllowDiagonals || options == null || options.length == 0 || (options[0] == null || options[0].field_186287_m == PathNodeType.OPEN || options[0].field_186286_l != 0.0f) && (options.length <= 1 || options[1] == null || options[1].field_186287_m == PathNodeType.OPEN || options[1].field_186286_l != 0.0f);
    }

    private boolean isPassableWithExemptions(IBlockAccess blockAccess, int x, int y, int z, @Nullable EnumSet<EnumFacing> exemptions, @Nullable EnumSet<EnumFacing> requirement, @Nullable EnumSet<EnumFacing> found) {
        if (requirement != null && found == null) {
            found = EnumSet.noneOf(EnumFacing.class);
        }
        for (int xo = 0; xo < this.field_176168_c; ++xo) {
            for (int yo = 0; yo < this.field_176165_d; ++yo) {
                for (int zo = 0; zo < this.field_176166_e; ++zo) {
                    PathNodeType nodeType = this.getPathNodeTypeWithConditions(blockAccess, x + xo, y + yo, z + zo, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacings, exemptions, found);
                    if (nodeType == PathNodeType.OPEN || !(this.field_186326_b.func_184643_a(nodeType) >= 0.0f)) continue;
                    if (requirement != null) {
                        for (EnumFacing facing : requirement) {
                            if (!found.contains(facing)) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        int k;
        int k2;
        boolean foundDiagonal;
        boolean allowOuterCorners;
        EnumSet<EnumFacing> found;
        int k3;
        int openedNodeCount = 0;
        int stepHeight = 0;
        PathNodeType nodeTypeAbove = this.getPathNodeTypeCached(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(nodeTypeAbove) >= 0.0f) {
            stepHeight = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos pos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double height = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)pos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)pos).field_72337_e);
        PathPoint[] pathsPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
        PathPoint[] pathsNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
        PathPoint[] pathsPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
        PathPoint[] pathsNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
        for (k3 = 0; k3 < pathsPZ.length; ++k3) {
            if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k3];
        }
        for (k3 = 0; k3 < pathsNX.length; ++k3) {
            if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k3];
        }
        for (k3 = 0; k3 < pathsPX.length; ++k3) {
            if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k3];
        }
        for (k3 = 0; k3 < pathsNZ.length; ++k3) {
            if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k3];
        }
        PathPoint[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            boolean hasValidPath = false;
            if (this.pathableFacings.size() > 1) {
                found = EnumSet.noneOf(EnumFacing.class);
                this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), null, found);
                hasValidPath = this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), found, null);
            }
            if (hasValidPath) {
                pathsNY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.DOWN, this.checkObstructions);
                for (int k4 = 0; k4 < pathsNY.length; ++k4) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY[k4], currentPoint, this.checkObstructions)) continue;
                    pathOptions[openedNodeCount++] = pathsNY[k4];
                }
            }
        }
        PathPoint[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            found = EnumSet.noneOf(EnumFacing.class);
            this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), null, found);
            if (this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), found, null)) {
                pathsPY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.UP, this.checkObstructions);
                for (int k5 = 0; k5 < pathsPY.length; ++k5) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY[k5], currentPoint, this.checkObstructions)) continue;
                    pathOptions[openedNodeCount++] = pathsPY[k5];
                }
            }
        }
        boolean allowDiagonalNZ = this.allowDiagonalPathOptions(pathsNZ);
        boolean allowDiagonalPZ = this.allowDiagonalPathOptions(pathsPZ);
        boolean allowDiagonalPX = this.allowDiagonalPathOptions(pathsPX);
        boolean allowDiagonalNX = this.allowDiagonalPathOptions(pathsNX);
        boolean fitsThroughPoles = this.field_186326_b.field_70130_N < 0.5f;
        boolean bl = allowOuterCorners = this.pathableFacings.size() >= 3;
        if (allowDiagonalNZ && allowDiagonalNX) {
            PathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - this.field_176168_c, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNX, pathsNZ, pathsNXNZ[k2], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_176168_c == 1 && this.field_176166_e == 1)) {
                pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - this.field_176166_e, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNX, pathsNZ, pathsNXNZ[k2], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                }
            }
        }
        if (allowDiagonalNZ && allowDiagonalPX) {
            PathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPX, pathsNZ, pathsPXNZ[k], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalNX) {
            PathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNX, pathsPZ, pathsNXPZ[k], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalPX) {
            PathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + this.field_176168_c, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPX, pathsPZ, pathsPXPZ[k2], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_176168_c == 1 && this.field_176166_e == 1)) {
                pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + this.field_176166_e, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPX, pathsPZ, pathsPXPZ[k2], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                }
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k6;
            int k7;
            boolean foundDiagonal2;
            boolean allowDiagonalPY = this.allowDiagonalPathOptions(pathsPY);
            boolean allowDiagonalNY = this.allowDiagonalPathOptions(pathsNY);
            if (allowDiagonalNY && allowDiagonalNX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.EAST), null, null)) {
                PathPoint[] pathsNYNX = this.getSafePoints(currentPoint.field_75839_a - this.field_176168_c, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsNX, pathsNYNX[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176168_c == 1 && this.field_176165_d == 1)) {
                    pathsNYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b - this.field_176165_d, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                        if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsNX, pathsNYNX[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.WEST), null, null)) {
                PathPoint[] pathsNYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPX.length; ++k6) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsPX, pathsNYPX[k6], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k6];
                }
            }
            if (allowDiagonalNY && allowDiagonalNZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.SOUTH), null, null)) {
                PathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - this.field_176165_d, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsNZ, pathsNYNZ[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176165_d == 1 && this.field_176166_e == 1)) {
                    pathsNYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c - this.field_176166_e, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                        if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsNZ, pathsNYNZ[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.NORTH), null, null)) {
                PathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPZ.length; ++k6) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsNY, pathsPZ, pathsNYPZ[k6], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalNX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.EAST), null, null)) {
                PathPoint[] pathsPYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNX.length; ++k6) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsNZ, pathsPYNX[k6], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.WEST), null, null)) {
                PathPoint[] pathsPYPX = this.getSafePoints(currentPoint.field_75839_a + this.field_176168_c, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsPX, pathsPYPX[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176168_c == 1 && this.field_176165_d == 1)) {
                    pathsPYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b + this.field_176165_d, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                        if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsPX, pathsPYPX[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    }
                }
            }
            if (allowDiagonalPY && allowDiagonalNZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.SOUTH), null, null)) {
                PathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNZ.length; ++k6) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsNZ, pathsPYNZ[k6], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.NORTH), null, null)) {
                PathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + this.field_176165_d, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                    if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsPZ, pathsPYPZ[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176165_d == 1 && this.field_176166_e == 1)) {
                    pathsPYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c + this.field_176166_e, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                        if (!AdvancedWalkNodeProcessor.isSuitablePoint(pathsPY, pathsPZ, pathsPYPZ[k7], this.checkObstructions, fitsThroughPoles, allowOuterCorners)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    }
                }
            }
        }
        return openedNodeCount;
    }

    private static boolean isSuitablePoint(@Nullable PathPoint newPoint, PathPoint currentPoint, boolean allowObstructions) {
        return newPoint != null && !newPoint.field_75842_i && (allowObstructions || newPoint.field_186286_l >= 0.0f || currentPoint.field_186286_l < 0.0f);
    }

    private static boolean isSuitablePoint(@Nullable PathPoint[] newPoints1, @Nullable PathPoint[] newPoints2, @Nullable PathPoint newPointDiagonal, boolean allowObstructions, boolean fitsThroughPoles, boolean allowOuterCorners) {
        if (!allowOuterCorners) {
            if (newPointDiagonal != null && !newPointDiagonal.field_75842_i && newPoints2 != null && newPoints2.length > 0 && (newPoints2[0] != null || newPoints2.length > 1 && newPoints2[1] != null) && newPoints1 != null && newPoints1.length > 0 && (newPoints1[0] != null || newPoints1.length > 1 && newPoints1[1] != null)) {
                if (!(newPoints1[0] != null && newPoints1[0].field_186287_m == PathNodeType.DOOR_OPEN || newPoints2[0] != null && newPoints2[0].field_186287_m == PathNodeType.DOOR_OPEN || newPointDiagonal.field_186287_m == PathNodeType.DOOR_OPEN)) {
                    boolean canPassPoleDiagonally = newPoints2[0] != null && newPoints2[0].field_186287_m == PathNodeType.FENCE && newPoints1[0] != null && newPoints1[0].field_186287_m == PathNodeType.FENCE && fitsThroughPoles;
                    return (allowObstructions || newPointDiagonal.field_186286_l >= 0.0f) && (canPassPoleDiagonally || (newPoints2[0] != null && (allowObstructions || newPoints2[0].field_186286_l >= 0.0f) || newPoints2.length > 1 && newPoints2[1] != null && (allowObstructions || newPoints2[1].field_186286_l >= 0.0f)) && (newPoints1[0] != null && (allowObstructions || newPoints1[0].field_186286_l >= 0.0f) || newPoints1.length > 1 && newPoints1[1] != null && (allowObstructions || newPoints1[1].field_186286_l >= 0.0f)));
                }
                return false;
            }
            return false;
        }
        if (newPointDiagonal != null && !newPointDiagonal.field_75842_i) {
            return (allowObstructions || newPointDiagonal.field_186286_l >= 0.0f) && (newPoints2 == null || newPoints2.length > 0 && (newPoints2[0] == null || allowObstructions || newPoints2[0].field_186286_l >= 0.0f || newPoints2[0].field_186287_m == PathNodeType.OPEN) || newPoints2 == null || newPoints2.length > 1 && (newPoints2[1] == null || allowObstructions || newPoints2[1].field_186286_l >= 0.0f || newPoints2[1].field_186287_m == PathNodeType.OPEN)) && (newPoints1 == null || newPoints1.length > 0 && (newPoints1[0] == null || allowObstructions || newPoints1[0].field_186286_l >= 0.0f || newPoints1[0].field_186287_m == PathNodeType.OPEN) || newPoints1 == null || newPoints1.length > 1 && (newPoints1[1] == null || allowObstructions || newPoints1[1].field_186286_l >= 0.0f || newPoints1[1].field_186287_m == PathNodeType.OPEN));
        }
        return false;
    }

    @Nullable
    private PathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, EnumFacing facing, boolean allowBlocked) {
        PathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos posDown = pos.func_177977_b();
        double blockHeight = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)posDown).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)posDown).field_72337_e);
        if (blockHeight - height > 1.125) {
            return new PathPoint[0];
        }
        PathNodeType nodeType = this.getPathNodeTypeCached(this.field_186326_b, x, y, z);
        float malus = ((IAdvancedPathFindingEntity)this.obstructionAwareEntity).getPathingMalus((EntityLiving)this.obstructionAwareEntity, nodeType, pos);
        double halfWidth = (double)this.field_186326_b.field_70130_N / 2.0;
        PathPoint[] result = new PathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != PathNodeType.BLOCKED)) {
            directPathPoint = this.func_176159_a(x, y, z);
            directPathPoint.field_186287_m = nodeType;
            directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
            if (directPathPoint.field_186287_m == PathNodeType.BLOCKED) {
                result = new PathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == PathNodeType.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != PathNodeType.FENCE && nodeType != PathNodeType.TRAPDOOR && facing.func_176740_k() != EnumFacing.Axis.Y) {
            PathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, facing, false);
            PathPoint pathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.field_186287_m == PathNodeType.OPEN || directPathPoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
                double jumpX = (double)(x - facing.func_82601_c()) + 0.5;
                double jumpZ = (double)(z - facing.func_82599_e()) + 0.5;
                AxisAlignedBB jumpBox = new AxisAlignedBB(jumpX - halfWidth, (double)y + 0.001, jumpZ - halfWidth, jumpX + halfWidth, (double)((float)y + this.field_186326_b.field_70131_O), jumpZ + halfWidth);
                AxisAlignedBB blockBox = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
                AxisAlignedBB checkBox = jumpBox.func_72321_a(0.0, blockBox.field_72337_e - 0.002, 0.0);
                if (this.checkAabbCollision(checkBox)) {
                    directPathPoint = null;
                }
            }
        }
        if (nodeType == PathNodeType.OPEN) {
            float bridingMalus;
            directPathPoint = null;
            AxisAlignedBB checkAabb = new AxisAlignedBB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + halfWidth + 0.5);
            if (this.checkAabbCollision(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f) {
                for (EnumFacing pathableFacing : this.pathableFacings) {
                    PathNodeType nodeTypeAtFacing = this.getPathNodeTypeCached(this.field_186326_b, x + pathableFacing.func_82601_c() * this.pathingSizeOffsetX, y + (pathableFacing == EnumFacing.DOWN ? -1 : (pathableFacing == EnumFacing.UP ? this.pathingSizeOffsetY : 0)), z + pathableFacing.func_82599_e() * this.pathingSizeOffsetZ);
                    if (nodeTypeAtFacing != PathNodeType.BLOCKED) continue;
                    directPathPoint = this.func_176159_a(x, y, z);
                    directPathPoint.field_186287_m = PathNodeType.WALKABLE;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            PathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > 0 && nodeType == PathNodeType.OPEN) {
                if (fallDistance++ >= Math.max(1, this.field_186326_b.func_82143_as()) || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                nodeType = this.getPathNodeTypeCached(this.field_186326_b, x, y, z);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if ((this.field_186326_b.func_82143_as() > 0 && nodeType != PathNodeType.OPEN || nodeType == PathNodeType.WATER || nodeType == PathNodeType.LAVA) && malus >= 0.0f) {
                    fallPathPoint = this.func_176159_a(x, y, z);
                    fallPathPoint.field_186287_m = nodeType;
                    fallPathPoint.field_186286_l = Math.max(fallPathPoint.field_186286_l, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                nodeType = this.getPathNodeTypeCached(this.field_186326_b, x, preFallY, z);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if (nodeType != PathNodeType.OPEN && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new PathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.func_176159_a(x, preFallY, z);
                    directPathPoint.field_186287_m = nodeType;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new PathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = ((IAdvancedPathFindingEntity)this.obstructionAwareEntity).getBridgePathingMalus((EntityLiving)this.obstructionAwareEntity, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new PathPoint[2];
                result[0] = directPathPoint;
                PathPoint bridgePathPoint = this.func_176159_a(x, preFallY, z);
                bridgePathPoint.field_186287_m = PathNodeType.WALKABLE;
                bridgePathPoint.field_186286_l = Math.max(bridgePathPoint.field_186286_l, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        result[0] = directPathPoint;
        return result;
    }

    private PathNodeType getPathNodeTypeCached(EntityLiving entitylivingIn, BlockPos pos) {
        return this.func_186330_a(this.field_176169_a, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private PathNodeType getPathNodeTypeCached(EntityLiving entitylivingIn, int x, int y, int z) {
        return (PathNodeType)this.pathNodeTypeCache.computeIfAbsent((Object)new BlockPos(x, y, z).func_177986_g(), key -> this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c()));
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        BlockPos pos = new BlockPos(entity.func_174791_d());
        EnumSet<PathNodeType> applicablePathNodeTypes = EnumSet.noneOf(PathNodeType.class);
        PathNodeType centerPathNodeType = this.func_193577_a(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, PathNodeType.BLOCKED, pos);
        if (applicablePathNodeTypes.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType selectedPathNodeType = PathNodeType.BLOCKED;
        for (PathNodeType applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.func_184643_a(applicablePathNodeType) < 0.0f) {
                return applicablePathNodeType;
            }
            float p1 = entity.func_184643_a(applicablePathNodeType);
            if (!(p1 > (p2 = entity.func_184643_a(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == PathNodeType.WALKABLE && applicablePathNodeType == PathNodeType.OPEN) && (p1 != p2 || selectedPathNodeType != PathNodeType.OPEN || applicablePathNodeType != PathNodeType.WALKABLE)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == PathNodeType.OPEN && entity.func_184643_a(selectedPathNodeType) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return selectedPathNodeType;
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        return this.getPathNodeTypeWithConditions(blockaccessIn, x, y, z, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacings, EnumSet.noneOf(EnumFacing.class), null);
    }

    protected PathNodeType getPathNodeTypeWithConditions(IBlockAccess blockaccessIn, int x, int y, int z, int pathingSizeOffsetX, int pathingSizeOffsetY, int pathingSizeOffsetZ, EnumSet<EnumFacing> pathableFacings, @Nullable EnumSet<EnumFacing> exemptions, @Nullable EnumSet<EnumFacing> found) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        PathNodeType nodeType = this.func_189553_b(blockaccessIn, x, y, z);
        if (nodeType == PathNodeType.OPEN && y >= 1) {
            block0: for (EnumFacing pathableFacing : pathableFacings) {
                if (exemptions != null && exemptions.contains(pathableFacing)) continue;
                int checkHeight = pathableFacing.func_176740_k() != EnumFacing.Axis.Y ? Math.min(4, pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.func_82601_c() * pathingSizeOffsetX;
                int cy = y + (pathableFacing == EnumFacing.DOWN ? -1 : (pathableFacing == EnumFacing.UP ? pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.func_82599_e() * pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.func_181079_c(cx, cy + yo, cz);
                    PathNodeType offsetNodeType = this.func_189553_b(blockaccessIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    PathNodeType pathNodeType = nodeType = offsetNodeType != PathNodeType.WALKABLE && offsetNodeType != PathNodeType.OPEN && offsetNodeType != PathNodeType.WATER && offsetNodeType != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
                    if (offsetNodeType == PathNodeType.DAMAGE_FIRE) {
                        nodeType = PathNodeType.DAMAGE_FIRE;
                    }
                    if (offsetNodeType == PathNodeType.DAMAGE_CACTUS) {
                        nodeType = PathNodeType.DAMAGE_CACTUS;
                    }
                    if (offsetNodeType == PathNodeType.DAMAGE_OTHER) {
                        nodeType = PathNodeType.DAMAGE_OTHER;
                    }
                    if (nodeType != PathNodeType.WALKABLE) continue;
                    if (found == null) break block0;
                    found.add(pathableFacing);
                    break block0;
                }
            }
        }
        if (nodeType == PathNodeType.WALKABLE) {
            nodeType = this.func_193578_a(blockaccessIn, x, y, z, nodeType);
        }
        return nodeType;
    }
}

