/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class CollisionSmoothingUtil {
    private static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    private static float sampleSdf(float[] erx, float[] ery, float[] erz, float[] ecx, float[] ecy, float[] ecz, float x, float y, float z, float smoothingRange, float invSmoothingRange) {
        float sdfDst = 0.0f;
        boolean first = true;
        for (int i = 0; i < erx.length; ++i) {
            float rsx = x - ecx[i];
            float rsy = y - ecy[i];
            float rsz = z - ecz[i];
            float prx = rsx * erx[i];
            float pry = rsy * ery[i];
            float prz = rsz * erz[i];
            float k1 = CollisionSmoothingUtil.invSqrt(prx * prx + pry * pry + prz * prz);
            float ellipsoidDst = MathHelper.func_76129_c((float)(rsx * rsx + rsy * rsy + rsz * rsz)) * (1.0f - 1.0f * k1);
            if (!first) {
                float h = MathHelper.func_76131_a((float)(0.5f + 0.5f * (ellipsoidDst - sdfDst) * invSmoothingRange), (float)0.0f, (float)1.0f);
                sdfDst = ellipsoidDst + (sdfDst - ellipsoidDst) * h - smoothingRange * h * (1.0f - h);
                continue;
            }
            sdfDst = ellipsoidDst;
            first = false;
        }
        return sdfDst;
    }

    @Nullable
    public static Pair<Vec3d, Vec3d> findClosestPoint(List<AxisAlignedBB> boxes, float smoothingRange, float boxScale, float dx, int iters, float threshold, Vec3d p) {
        if (boxes.isEmpty()) {
            return null;
        }
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        float invSmoothingRange = 1.0f / smoothingRange;
        float[] erx = new float[boxes.size()];
        float[] ery = new float[boxes.size()];
        float[] erz = new float[boxes.size()];
        float[] ecx = new float[boxes.size()];
        float[] ecy = new float[boxes.size()];
        float[] ecz = new float[boxes.size()];
        int i = 0;
        for (AxisAlignedBB box : boxes) {
            erx[i] = 1.0f / ((float)(box.field_72336_d - box.field_72340_a) / 2.0f * boxScale);
            ery[i] = 1.0f / ((float)(box.field_72337_e - box.field_72338_b) / 2.0f * boxScale);
            erz[i] = 1.0f / ((float)(box.field_72334_f - box.field_72339_c) / 2.0f * boxScale);
            ecx[i] = (float)((box.field_72340_a + box.field_72336_d) / 2.0 - p.field_72450_a);
            ecy[i] = (float)((box.field_72338_b + box.field_72337_e) / 2.0 - p.field_72448_b);
            ecz[i] = (float)((box.field_72339_c + box.field_72334_f) / 2.0 - p.field_72449_c);
            ++i;
        }
        for (int j = 0; j < iters; ++j) {
            float m;
            float dst = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, px, py, pz, smoothingRange, invSmoothingRange);
            float fx1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, px + dx, py, pz, smoothingRange, invSmoothingRange);
            float fy1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, px, py + dx, pz, smoothingRange, invSmoothingRange);
            float fz1 = CollisionSmoothingUtil.sampleSdf(erx, ery, erz, ecx, ecy, ecz, px, py, pz + dx, smoothingRange, invSmoothingRange);
            float gx = dst - fx1;
            float gy = dst - fy1;
            float gz = dst - fz1;
            if (Float.isNaN(gx *= (m = CollisionSmoothingUtil.invSqrt(gx * gx + gy * gy + gz * gz))) || Float.isNaN(gy *= m) || Float.isNaN(gz *= m) || Double.isNaN(px) || Double.isNaN(py) || Double.isNaN(pz)) {
                return null;
            }
            float step = Math.max(dst, threshold / 2.0f);
            px += gx * step;
            py += gy * step;
            pz += gz * step;
            if (!(dst < threshold)) continue;
            return Pair.of((Object)new Vec3d(p.field_72450_a + (double)px, p.field_72448_b + (double)py, p.field_72449_c + (double)pz), (Object)new Vec3d((double)(-gx), (double)(-gy), (double)(-gz)).func_72432_b());
        }
        return null;
    }
}

