/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.core;

import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.api.upgrade.BackpackUpgrade;
import gr8pefish.ironbackpacks.api.upgrade.IUpgrade;
import gr8pefish.ironbackpacks.capabilities.PlayerBackpackHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void attachPlayerCaps(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(new ResourceLocation("ironbackpacks", "equipped_backpack"), (ICapabilityProvider)new PlayerBackpackHandler.Default());
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        ItemStack removed;
        ItemStack upgraded = EventHandler.tryUpgradeBackpack(event.getLeft(), event.getRight());
        if (!upgraded.func_190926_b()) {
            event.setOutput(upgraded);
            event.setCost(1);
            event.setMaterialCost(1);
        } else if (event.getRight().func_77973_b() instanceof ItemShears && !(removed = EventHandler.tryRemoveUpgrade(event.getLeft())).func_190926_b()) {
            event.setOutput(removed);
            event.setCost(1);
            event.setMaterialCost(0);
        }
    }

    @SubscribeEvent
    public static void onAnvilPost(AnvilRepairEvent event) {
        if (event.getItemResult().func_190926_b() || !(event.getItemResult().func_77973_b() instanceof IUpgrade)) {
            return;
        }
        event.setBreakChance(0.0f);
        if (event.getItemInput().func_190926_b() || !(event.getItemInput().func_77973_b() instanceof IBackpack)) {
            return;
        }
        if (event.getIngredientInput().func_190926_b() || !(event.getIngredientInput().func_77973_b() instanceof ItemShears)) {
            return;
        }
        BackpackUpgrade upgrade = ((IUpgrade)event.getItemResult().func_77973_b()).getUpgrade(event.getItemResult());
        IBackpack backpack = (IBackpack)event.getItemInput().func_77973_b();
        BackpackInfo info = backpack.getBackpackInfo(event.getItemInput());
        info.removeUpgrade(upgrade);
        backpack.updateBackpack(event.getItemInput(), info);
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)event.getItemInput());
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)event.getIngredientInput());
    }

    @Nonnull
    private static ItemStack tryUpgradeBackpack(ItemStack left, ItemStack right) {
        if (left.func_190926_b() || !(left.func_77973_b() instanceof IBackpack)) {
            return ItemStack.field_190927_a;
        }
        if (right.func_190926_b() || !(right.func_77973_b() instanceof IUpgrade)) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = left.func_77946_l();
        IBackpack backpack = (IBackpack)output.func_77973_b();
        BackpackInfo packInfo = backpack.getBackpackInfo(output);
        BackpackUpgrade upgrade = ((IUpgrade)right.func_77973_b()).getUpgrade(right);
        if (upgrade.isNull() || packInfo.getVariant().getBackpackType().isNull()) {
            return ItemStack.field_190927_a;
        }
        if (packInfo.conflicts(upgrade)) {
            return ItemStack.field_190927_a;
        }
        if (packInfo.getMaxPoints() - packInfo.getPointsUsed() < upgrade.getApplicationCost()) {
            return ItemStack.field_190927_a;
        }
        if (packInfo.hasUpgrade(upgrade)) {
            return ItemStack.field_190927_a;
        }
        if (packInfo.getVariant().getBackpackType().getTier() < upgrade.getMinimumTier()) {
            return ItemStack.field_190927_a;
        }
        packInfo.addUpgrade(upgrade);
        backpack.updateBackpack(output, packInfo);
        return output;
    }

    @Nonnull
    private static ItemStack tryRemoveUpgrade(ItemStack left) {
        if (left.func_190926_b() || !(left.func_77973_b() instanceof IBackpack)) {
            return ItemStack.field_190927_a;
        }
        BackpackInfo packInfo = ((IBackpack)left.func_77973_b()).getBackpackInfo(left);
        List<BackpackUpgrade> upgrades = packInfo.getUpgrades();
        if (upgrades.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        BackpackUpgrade upgrade = upgrades.get(upgrades.size() - 1);
        return IronBackpacksAPI.getStack(upgrade);
    }
}

