/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackVariant;
import gr8pefish.ironbackpacks.api.blacklist.IInventoryBlacklist;
import gr8pefish.ironbackpacks.api.upgrade.BackpackUpgrade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class IronBackpacksAPI {
    public static final ResourceLocation NULL = new ResourceLocation("ironbackpacks", "null");
    private static final IInventoryBlacklist INVENTORY_BLACKLIST = null;
    @GameRegistry.ObjectHolder(value="ironbackpacks:backpack")
    public static Item BACKPACK_ITEM = Items.field_190931_a;
    @GameRegistry.ObjectHolder(value="ironbackpacks:upgrade")
    public static Item UPGRADE_ITEM = Items.field_190931_a;
    private static IForgeRegistry<BackpackType> backpackTypeRegistry = null;
    private static IForgeRegistry<BackpackUpgrade> upgradeRegistry = null;
    private static ArrayList<BackpackVariant> backpackVariantList = new ArrayList();

    @Nonnull
    public static IForgeRegistry<BackpackType> getBackpackTypeRegistry() {
        return backpackTypeRegistry == null ? (backpackTypeRegistry = GameRegistry.findRegistry(BackpackType.class)) : backpackTypeRegistry;
    }

    @Nonnull
    public static BackpackType getBackpackType(@Nonnull ResourceLocation identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier cannot be null");
        return (BackpackType)IronBackpacksAPI.getBackpackTypeRegistry().getValue(identifier);
    }

    @Nonnull
    public static Set<BackpackType> getBackpackTypes() {
        return ImmutableSet.copyOf((Collection)IronBackpacksAPI.getBackpackTypeRegistry().getValues());
    }

    @Nonnull
    public static IForgeRegistry<BackpackUpgrade> getUpgradeRegistry() {
        return upgradeRegistry == null ? (upgradeRegistry = GameRegistry.findRegistry(BackpackUpgrade.class)) : upgradeRegistry;
    }

    @Nonnull
    public static BackpackUpgrade getUpgrade(@Nonnull ResourceLocation identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier cannot be null");
        return (BackpackUpgrade)IronBackpacksAPI.getUpgradeRegistry().getValue(identifier);
    }

    @Nonnull
    public static Set<BackpackUpgrade> getUpgrades() {
        return ImmutableSet.copyOf((Collection)IronBackpacksAPI.getUpgradeRegistry().getValues());
    }

    @Nonnull
    public static ItemStack getStack(@Nonnull BackpackUpgrade backpackUpgrade) {
        Preconditions.checkNotNull((Object)((Object)backpackUpgrade), (Object)"BackpackUpgrade cannot be null");
        ItemStack stack = new ItemStack(UPGRADE_ITEM);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("upgrade", backpackUpgrade.getIdentifier().toString());
        return stack;
    }

    @Nonnull
    public static ItemStack getStack(@Nonnull BackpackVariant backpackVariant) {
        Preconditions.checkNotNull((Object)backpackVariant, (Object)"BackpackVariant cannot be null");
        ItemStack stack = new ItemStack(BACKPACK_ITEM);
        BackpackInfo backpackInfo = new BackpackInfo(backpackVariant);
        return IronBackpacksAPI.applyPackInfo(stack, backpackInfo);
    }

    @Nonnull
    public static ItemStack getStack(@Nonnull BackpackType backpackType, @Nonnull BackpackSpecialty backpackSpecialty) {
        Preconditions.checkNotNull((Object)((Object)backpackType), (Object)"BackpackType cannot be null");
        Preconditions.checkNotNull((Object)((Object)backpackSpecialty), (Object)"BackpackSpecialty cannot be null");
        ItemStack stack = new ItemStack(BACKPACK_ITEM);
        BackpackInfo backpackInfo = new BackpackInfo(new BackpackVariant(backpackType, backpackSpecialty));
        return IronBackpacksAPI.applyPackInfo(stack, backpackInfo);
    }

    @Nonnull
    public static ItemStack applyPackInfo(@Nonnull ItemStack stack, @Nonnull BackpackInfo backpackInfo) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        Preconditions.checkNotNull((Object)backpackInfo, (Object)"BackpackInfo cannot be null");
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("packInfo", (NBTBase)backpackInfo.serializeNBT());
        if (backpackInfo.getInventory() != null) {
            NBTTagList invTag = new NBTTagList();
            for (int i = 0; i < backpackInfo.getInventory().getSlots(); ++i) {
                invTag.func_74742_a((NBTBase)backpackInfo.getInventory().getStackInSlot(i).serializeNBT());
            }
            stack.func_77978_p().func_74782_a("packInv", (NBTBase)invTag);
        }
        return stack;
    }

    public static void initBackpackVariantList() {
        ArrayList sortedTypes = Lists.newArrayList(IronBackpacksAPI.getBackpackTypes());
        sortedTypes.sort(Comparator.comparingInt(BackpackType::getTier));
        for (BackpackType backpackType : sortedTypes) {
            if (backpackType.getIdentifier().equals((Object)NULL)) continue;
            if (!backpackType.hasSpecialties()) {
                backpackVariantList.add(new BackpackVariant(backpackType, BackpackSpecialty.NONE));
                continue;
            }
            for (BackpackSpecialty specialty : BackpackSpecialty.values()) {
                if (specialty == BackpackSpecialty.NONE) continue;
                backpackVariantList.add(new BackpackVariant(backpackType, specialty));
            }
        }
    }

    @Nonnull
    public static List<BackpackVariant> getBackpackVariantList() {
        return ImmutableList.copyOf(backpackVariantList);
    }

    @Nullable
    public static BackpackVariant getBackpackVariantFromList(@Nonnull BackpackType type, @Nonnull BackpackSpecialty specialty) {
        Preconditions.checkNotNull((Object)((Object)specialty), (Object)"Specialty cannot be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null");
        List<BackpackVariant> list = IronBackpacksAPI.getBackpackVariantList();
        for (BackpackVariant backpackVariant : list) {
            if (backpackVariant.getBackpackType() != type || backpackVariant.getBackpackSpecialty() != specialty) continue;
            return backpackVariant;
        }
        return null;
    }

    public static IInventoryBlacklist getInventoryBlacklist() {
        if (INVENTORY_BLACKLIST == null) {
            throw new RuntimeException("Attempted to access inventory blacklist before it was available. Please do this during FMLPostInitializationEvent to ensure it is ready.");
        }
        return INVENTORY_BLACKLIST;
    }
}

