/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;

public class ToolHelper {
    public static Set<String> getToolClassesOf(@Nonnull ItemStack tool) {
        return tool.func_77973_b().getToolClasses(tool);
    }

    public static boolean isToolOfClass(@Nonnull ItemStack tool, String toolClass) {
        return ToolHelper.getToolClassesOf(tool).contains(toolClass);
    }

    public static boolean toolHasAnyToolClass(@Nonnull ItemStack tool) {
        return !ToolHelper.getToolClassesOf(tool).isEmpty();
    }

    public static boolean isToolEffectiveAgainst(@Nonnull ItemStack tool, IBlockAccess blockAccess, BlockPos blockPos, String effectiveToolClass) {
        return ForgeHooks.isToolEffective((IBlockAccess)blockAccess, (BlockPos)blockPos, (ItemStack)tool) || (ToolHelper.toolHasAnyToolClass(tool) ? ToolHelper.isToolOfClass(tool, effectiveToolClass) : tool.func_77973_b().func_150893_a(tool, blockAccess.func_180495_p(blockPos)) > 1.5f);
    }

    public static boolean canToolHarvestLevel(@Nonnull ItemStack tool, IBlockAccess blockAccess, BlockPos blockPos, EntityPlayer player, int harvestLevel) {
        IBlockState state = blockAccess.func_180495_p(blockPos);
        state = state.func_177230_c().func_176221_a(state, blockAccess, blockPos);
        String harvestTool = state.func_177230_c().getHarvestTool(state);
        return !tool.func_190926_b() && harvestTool != null && tool.func_77973_b().getHarvestLevel(tool, harvestTool, player, state) >= harvestLevel;
    }

    public static boolean canToolHarvestBlock(@Nonnull ItemStack tool, IBlockState blockState) {
        return blockState.func_185904_a().func_76229_l() || tool.func_150998_b(blockState);
    }

    public static int getToolHarvestLevel(ItemTool tool, @Nonnull ItemStack toolStack) {
        Set<String> toolClasses = ToolHelper.getToolClassesOf(toolStack);
        if (toolClasses.isEmpty()) {
            return 0;
        }
        String toolClass = toolClasses.iterator().next();
        return tool.getHarvestLevel(toolStack, toolClass, null, null);
    }
}

