/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAIAggressiveTouch;
import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAIAlwaysAggressive;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ZombiePigmanFeatures
extends EntityFeatures {
    private boolean aggressiveTouch;
    private boolean alwaysAggressive;
    private int aggressiveRange;
    private float aggressiveBlockRange;
    private int aggressiveBlockChance;

    public ZombiePigmanFeatures() {
        super("zombie pigman", EntityPigZombie.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.aggressiveTouch = RoughConfig.getBoolean(this.name, "AggressiveTouch", false, "Set to false to prevent zombie pigman from getting aggressive if the player touches its hitbox");
        this.alwaysAggressive = RoughConfig.getBoolean(this.name, "AlwaysAggressive", true, "Set to true for zombie pigmen to always be aggressive");
        this.aggressiveRange = RoughConfig.getInteger(this.name, "AggressionRange", 10, 0, Short.MAX_VALUE, "The range at which zombie pigmen will be aggressive to the player.");
        this.aggressiveBlockRange = RoughConfig.getFloat(this.name, "AggressiveBlockRange", 20.0f, 1.0f, 32767.0f, "Block radius in which zombie pigman get aggressive if the player breaks blocks");
        this.aggressiveBlockChance = RoughConfig.getInteger(this.name, "AggressiveBlockChance", 10, 0, Short.MAX_VALUE, "Chance (1 in X) that a zombie pigman gets aggressive if the player breaks nearby blocks");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityLiving && this.aggressiveTouch) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIAggressiveTouch((EntityLiving)entity));
        }
        if (entity instanceof EntityLiving && this.alwaysAggressive) {
            tasks.func_75776_a(3, (EntityAIBase)new RoughAIAlwaysAggressive((EntityLiving)entity, this.aggressiveRange));
        }
    }

    @Override
    public void onBlockBreak(EntityPlayer player, BlockEvent.BreakEvent event) {
        for (Class clazz : this.entityClasses) {
            List entities = player.field_70170_p.func_72872_a(clazz, player.func_174813_aQ().func_72321_a((double)this.aggressiveBlockRange, (double)this.aggressiveBlockRange, (double)this.aggressiveBlockRange));
            for (Entity entity : entities) {
                if (this.aggressiveBlockChance <= 0 || !(entity instanceof EntityLiving) || player.field_70170_p.field_73012_v.nextInt(this.aggressiveBlockChance) != 0) continue;
                EntityLiving living = (EntityLiving)entity;
                living.func_70624_b((EntityLivingBase)player);
                living.func_70604_c((EntityLivingBase)player);
                FeatureHelper.playSound((Entity)living, SoundEvents.field_187936_hj);
            }
        }
    }
}

