/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.misc.MountHelper;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class SpiderFeatures
extends EntityFeatures {
    private float ignoreFallDamageMult;
    private int slownessChance;
    private int slownessDuration;
    private boolean slownessCreateWeb;
    private MountHelper.Rider rider;

    public SpiderFeatures() {
        super("spider", EntitySpider.class, EntityCaveSpider.class);
    }

    @Override
    public void preInit() {
        this.rider = new MountHelper.Rider(this.name, Constants.DEFAULT_SPIDER_RIDERS, 10);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.ignoreFallDamageMult = RoughConfig.getFloat(this.name, "IgnoreFallDamageMult", 0.0f, 0.0f, 1.0f, "The fall damage %ss take is multiplied by this value (0.0 means no fall damage, 1.0 means normal full damage)");
        this.slownessDuration = RoughConfig.getInteger(this.name, "SlownessDuration", 200, 1, Short.MAX_VALUE, "Duration in ticks of the applied slowness effect (20 ticks = 1 second)");
        this.slownessChance = RoughConfig.getInteger(this.name, "SlownessChance", 1, 0, Short.MAX_VALUE, "Chance (1 in X) for a %s to apply the slowness effect on attack\nSet to 0 to disable this feature");
        this.slownessCreateWeb = RoughConfig.getBoolean(this.name, "SlownessCreateWeb", true, "Set this to false to prevent %ss from creating webs on slowed targets");
        this.rider.initConfigs();
    }

    @Override
    public void postInit() {
        this.rider.postInit();
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityLiving) {
            this.rider.addAI((EntityLiving)entity);
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, Entity entity) {
        if (entity instanceof EntityPlayer) {
            RoughMobs.logger.debug("Entity is player...skipping addFeatures");
            return;
        }
        if (entity instanceof EntityLivingBase) {
            this.rider.tryAddRider((EntityLivingBase)entity);
        }
    }

    @Override
    public void onFall(Entity entity, LivingFallEvent event) {
        if (this.ignoreFallDamageMult == 1.0f) {
            return;
        }
        if (this.ignoreFallDamageMult == 0.0f) {
            event.setCanceled(true);
        }
        event.setDamageMultiplier(event.getDamageMultiplier() * this.ignoreFallDamageMult);
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (target instanceof EntityLivingBase && this.slownessChance > 0) {
            EntityLivingBase living = (EntityLivingBase)target;
            int maxAmp = 4;
            FeatureHelper.addEffect(living, MobEffects.field_76421_d, this.slownessDuration, 0, this.slownessChance, true, maxAmp);
            PotionEffect active = living.func_70660_b(MobEffects.field_76421_d);
            if (this.slownessCreateWeb && active != null && active.func_76458_c() >= maxAmp && RND.nextInt(this.slownessChance) == 0 && target.func_130014_f_().func_180495_p(target.func_180425_c()).func_177230_c() == Blocks.field_150350_a) {
                target.func_130014_f_().func_175656_a(target.func_180425_c(), Blocks.field_150321_G.func_176223_P());
            }
        }
    }
}

