/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.utility.StructureHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class BiomeTraitStructure
extends BiomeTrait {
    protected List<ResourceLocation> structures;
    protected StructureType structureType;
    protected Mirror mirror;
    protected Rotation rotation;
    protected Block ignoredBlock;
    protected double clearancePercentage;
    protected boolean orientRandomly;

    protected BiomeTraitStructure(Builder builder) {
        super(builder);
        this.structures = builder.structures;
        this.structureType = builder.structureType;
        this.mirror = builder.mirror;
        this.rotation = builder.rotation;
        this.ignoredBlock = builder.ignoredBlock;
        this.clearancePercentage = builder.clearancePercentage;
        this.orientRandomly = builder.orientRandomly;
    }

    public static BiomeTraitStructure create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        IBlockState ignoredBlockState;
        super.readFromConfig(config);
        List structureNames = (List)config.getOrElse("structures", new ArrayList());
        this.structures = new ArrayList<ResourceLocation>();
        for (String structureName : structureNames) {
            this.structures.add(new ResourceLocation(structureName));
        }
        this.structureType = (StructureType)config.getEnumOrElse("structureType", (Enum)StructureType.GROUND);
        this.orientRandomly = (Boolean)config.getOrElse("orientRandomly", (Object)true);
        if (!this.orientRandomly) {
            this.mirror = (Mirror)config.getEnumOrElse("mirror", (Enum)RandomHelper.getEnum(Mirror.class));
            this.rotation = (Rotation)config.getEnumOrElse("rotation", (Enum)RandomHelper.getEnum(Rotation.class));
        }
        if ((ignoredBlockState = ConfigHelper.getBlockState(config, "ignoredBlock")) != null) {
            this.ignoredBlock = ignoredBlockState.func_177230_c();
        }
        this.clearancePercentage = (Double)config.getOrElse("clearancePercentage", (Object)0.875);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ArrayList<String> structureNames = new ArrayList<String>();
        for (ResourceLocation structureName : this.structures) {
            structureNames.add(structureName.toString());
        }
        config.add("structures", structureNames);
        config.add("structureType", (Object)this.structureType.toString().toLowerCase());
        if (!this.orientRandomly) {
            config.add("mirror", (Object)this.mirror);
            config.add("rotation", (Object)this.rotation);
        }
        ConfigHelper.setBlockState(config, "ignoredBlock", this.ignoredBlock.func_176223_P());
        config.add("clearancePercentage", (Object)this.clearancePercentage);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.structures == null || this.structureType == null || this.ignoredBlock == null) {
            return false;
        }
        if (this.orientRandomly) {
            this.mirror = RandomHelper.getEnum(Mirror.class, random);
            this.rotation = RandomHelper.getEnum(Rotation.class, random);
        }
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        Template template = templateManager.func_189942_b(server, this.structures.get(random.nextInt(this.structures.size())));
        if (template != null) {
            PlacementSettings placementSettings = new PlacementSettings().func_186214_a(this.mirror).func_186220_a(this.rotation).func_186225_a(this.ignoredBlock).func_189950_a(random);
            BlockPos structureSize = template.func_186257_a(placementSettings.func_186215_c());
            BlockPos spawnPos = null;
            if (this.structureType == StructureType.GROUND) {
                spawnPos = StructureHelper.getGroundPos(world, pos, structureSize, this.clearancePercentage);
            } else if (this.structureType == StructureType.AIR) {
                spawnPos = StructureHelper.getAirPos(world, pos, structureSize, this.clearancePercentage);
            } else if (this.structureType == StructureType.BURIED) {
                spawnPos = StructureHelper.getBuriedPos(world, pos, structureSize, this.clearancePercentage);
            } else if (this.structureType == StructureType.CEILING) {
                spawnPos = StructureHelper.getCeilingPos(world, pos, structureSize, this.clearancePercentage);
            }
            if (spawnPos != null && spawnPos.func_177956_o() >= this.minimumGenerationHeight && spawnPos.func_177956_o() <= this.maximumGenerationHeight) {
                template.func_186253_b(world, spawnPos, placementSettings.func_186217_a());
                this.handleDataBlocks(world, spawnPos, template, placementSettings.func_186217_a(), random);
                return true;
            }
        }
        if (this.orientRandomly) {
            this.mirror = null;
            this.rotation = null;
        }
        return false;
    }

    private void handleDataBlocks(World world, BlockPos pos, Template template, PlacementSettings placementSettings, Random random) {
        Map map = template.func_186258_a(pos, placementSettings);
        for (Map.Entry entry : map.entrySet()) {
            BlockPos dataPos = (BlockPos)entry.getKey();
            String[] data = ((String)entry.getValue()).split("\\s+");
            if (data[0].equals("chest") && data.length == 2) {
                world.func_175656_a(dataPos, Blocks.field_150486_ae.func_176458_f(world, dataPos, Blocks.field_150486_ae.func_176223_P()));
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(dataPos);
                if (chest == null) continue;
                chest.func_189404_a(new ResourceLocation(data[1]), random.nextLong());
                continue;
            }
            if (data[0].equals("spawner") && data.length == 2) {
                world.func_175656_a(dataPos, Blocks.field_150474_ac.func_176223_P());
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(dataPos);
                if (spawner == null) continue;
                MobSpawnerBaseLogic logic = spawner.func_145881_a();
                NBTTagCompound compound = new NBTTagCompound();
                logic.func_189530_b(compound);
                compound.func_82580_o("SpawnPotentials");
                logic.func_98270_a(compound);
                logic.func_190894_a(new ResourceLocation(data[1]));
                spawner.func_70296_d();
                IBlockState state = world.func_180495_p(dataPos);
                world.func_184138_a(pos, state, state, 3);
                continue;
            }
            if (data[0].equals("entity") && data.length == 2) {
                Entity entity = EntityList.func_191304_a((Class)EntityList.getClass((ResourceLocation)new ResourceLocation(data[1])), (World)world);
                if (entity == null) continue;
                entity.func_70107_b((double)((float)dataPos.func_177958_n() + 0.5f), (double)dataPos.func_177956_o(), (double)((float)dataPos.func_177952_p() + 0.5f));
                if (!world.func_72838_d(entity) || !(entity instanceof EntityLiving)) continue;
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(dataPos), null);
                continue;
            }
            world.func_175698_g(dataPos);
        }
    }

    public static enum StructureType {
        GROUND,
        AIR,
        CEILING,
        BURIED;

    }

    public static class Builder
    extends BiomeTrait.Builder<BiomeTraitStructure> {
        private List<ResourceLocation> structures = Collections.singletonList(new ResourceLocation("minecraft:missing_no"));
        private StructureType structureType = StructureType.GROUND;
        private Mirror mirror = Mirror.NONE;
        private Rotation rotation = Rotation.NONE;
        private Block ignoredBlock = Blocks.field_189881_dj;
        private double clearancePercentage = 0.75;
        private boolean orientRandomly = true;

        public Builder structures(List<ResourceLocation> structures) {
            this.structures = structures;
            return this;
        }

        public Builder structureType(StructureType structureType) {
            this.structureType = structureType;
            return this;
        }

        public Builder mirror(Mirror mirror) {
            this.mirror = mirror;
            return this;
        }

        public Builder rotation(Rotation rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder ignoredBlock(Block ignoredBlock) {
            this.ignoredBlock = ignoredBlock;
            return this;
        }

        public Builder clearancePercentage(double clearancePercentage) {
            this.clearancePercentage = clearancePercentage;
            return this;
        }

        public Builder orientRandomly(boolean orientRandomly) {
            this.orientRandomly = orientRandomly;
            return this;
        }

        @Override
        public BiomeTraitStructure create() {
            return new BiomeTraitStructure(this);
        }
    }
}

