/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeTraitScatter
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToTarget;
    protected Placement placement;

    protected BiomeTraitScatter(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToTarget = builder.blockToTarget;
        this.placement = builder.placement;
    }

    public static BiomeTraitScatter create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToTarget = ConfigHelper.getBlockState(config, "blockToTarget");
        this.placement = (Placement)config.getEnumOrElse("placement", (Enum)Placement.ON_GROUND);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
        ConfigHelper.setBlockState(config, "blockToTarget", this.blockToTarget);
        config.add("placement", this.placement == null ? null : this.placement.toString().toLowerCase());
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToTarget == null || this.placement == null) {
            return false;
        }
        for (int i = 0; i < 64; ++i) {
            BlockPos offsetPos;
            BlockPos newPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(newPos)) continue;
            if ((this.placement == Placement.ON_GROUND || this.placement == Placement.IN_GROUND) && world.func_180495_p(newPos.func_177977_b()) == this.blockToTarget) {
                offsetPos = this.placement.offsetPos(newPos);
                if (!this.blockToSpawn.func_177230_c().func_176196_c(world, offsetPos)) continue;
                world.func_180501_a(offsetPos, this.blockToSpawn, 3);
                continue;
            }
            if (this.placement != Placement.ON_ROOF && this.placement != Placement.IN_ROOF || world.func_180495_p(newPos.func_177984_a()) != this.blockToTarget) continue;
            offsetPos = this.placement.offsetPos(newPos);
            if (!this.blockToSpawn.func_177230_c().func_176196_c(world, offsetPos)) continue;
            world.func_180501_a(offsetPos, this.blockToSpawn, 3);
        }
        return true;
    }

    public static class Builder
    extends BiomeTrait.Builder<BiomeTraitScatter> {
        private IBlockState blockToSpawn = Blocks.field_150329_H.func_176223_P();
        private IBlockState blockToTarget = Blocks.field_150349_c.func_176223_P();
        private Placement placement = Placement.ON_GROUND;

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToTarget(IBlockState blockToTarget) {
            this.blockToTarget = blockToTarget;
            return this;
        }

        public Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public BiomeTraitScatter create() {
            return new BiomeTraitScatter(this);
        }
    }

    public static enum Placement {
        ON_GROUND(null),
        IN_GROUND(EnumFacing.DOWN),
        ON_ROOF(null),
        IN_ROOF(EnumFacing.UP);

        EnumFacing offset;

        private Placement(EnumFacing offsetIn) {
            this.offset = offsetIn;
        }

        public BlockPos offsetPos(BlockPos pos) {
            if (this.offset != null) {
                return pos.func_177972_a(this.offset);
            }
            return pos;
        }
    }
}

