/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitRegistry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BiomeTrait {
    protected int generationAttempts;
    protected boolean randomizeGenerationAttempts;
    protected double generationProbability;
    protected int minimumGenerationHeight;
    protected int maximumGenerationHeight;

    protected BiomeTrait(Builder builder) {
        this.generationAttempts = builder.generationAttempts;
        this.randomizeGenerationAttempts = builder.randomizeGenerationAttempts;
        this.generationProbability = builder.generationProbability;
        this.minimumGenerationHeight = builder.minimumGenerationHeight;
        this.maximumGenerationHeight = builder.maximumGenerationHeight;
    }

    public abstract boolean generate(World var1, BlockPos var2, Random var3);

    public void readFromConfig(Config config) {
        this.generationAttempts = (Integer)config.getOrElse("generationAttempts", (Object)4);
        this.randomizeGenerationAttempts = (Boolean)config.getOrElse("randomizeGenerationAttempts", (Object)false);
        this.generationProbability = (Double)config.getOrElse("generationProbability", (Object)1.0);
        this.minimumGenerationHeight = (Integer)config.getOrElse("minimumGenerationHeight", (Object)0);
        this.maximumGenerationHeight = (Integer)config.getOrElse("maximumGenerationHeight", (Object)255);
    }

    public void writeToConfig(Config config) {
        config.add("trait", (Object)BiomeTraitRegistry.INSTANCE.getBiomeTraitName(this.getClass()).toString());
        config.add("generationAttempts", (Object)this.generationAttempts);
        config.add("randomizeGenerationAttempts", (Object)this.randomizeGenerationAttempts);
        config.add("generationProbability", (Object)this.generationProbability);
        config.add("minimumGenerationHeight", (Object)this.minimumGenerationHeight);
        config.add("maximumGenerationHeight", (Object)this.maximumGenerationHeight);
    }

    public boolean useRandomizedGenerationAttempts() {
        return this.randomizeGenerationAttempts;
    }

    public int getGenerationAttempts(World world, BlockPos pos, Random random) {
        int attempts = 0;
        if (this.generationProbability >= random.nextDouble()) {
            attempts = this.generationAttempts;
            if (this.randomizeGenerationAttempts) {
                attempts = RandomHelper.getNumberInRange(1, attempts, random);
            }
        }
        return attempts;
    }

    public double getGenerationProbability(World world, BlockPos pos, Random random) {
        return this.generationProbability;
    }

    public int getMinimumGenerationHeight(World world, BlockPos pos, Random random) {
        return this.minimumGenerationHeight;
    }

    public int getMaximumGenerationHeight(World world, BlockPos pos, Random random) {
        return this.maximumGenerationHeight;
    }

    public static abstract class Builder<T extends BiomeTrait> {
        protected int generationAttempts = 4;
        protected boolean randomizeGenerationAttempts = false;
        protected double generationProbability = 1.0;
        protected int minimumGenerationHeight = 2;
        protected int maximumGenerationHeight = 60;

        public Builder<?> generationAttempts(int generationAttempts) {
            this.generationAttempts = generationAttempts;
            return this;
        }

        public Builder<?> randomizeGenerationAttempts(boolean randomizeGenerationAttempts) {
            this.randomizeGenerationAttempts = randomizeGenerationAttempts;
            return this;
        }

        public Builder<?> generationProbability(double generationProbability) {
            this.generationProbability = generationProbability;
            return this;
        }

        public Builder<?> minimumGenerationHeight(int minimumGenerationHeight) {
            this.minimumGenerationHeight = minimumGenerationHeight;
            return this;
        }

        public Builder<?> maximumGenerationHeight(int maximumGenerationHeight) {
            this.maximumGenerationHeight = maximumGenerationHeight;
            return this;
        }

        public abstract T create();
    }
}

