/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.spawn.impl;

import crazypants.enderzoo.spawn.IBiomeFilter;
import crazypants.enderzoo.spawn.ISpawnEntry;
import crazypants.enderzoo.spawn.impl.DimensionFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;

public class SpawnEntry
implements ISpawnEntry {
    private final String id;
    private final String mobName;
    private final int rate;
    private EnumCreatureType creatureType = EnumCreatureType.MONSTER;
    private int minGroupSize = 1;
    private int maxGroupSize = 3;
    private boolean isRemove = false;
    private final List<IBiomeFilter> filters = new ArrayList<IBiomeFilter>();
    private final List<DimensionFilter> dimFilters = new ArrayList<DimensionFilter>();

    public SpawnEntry(String id, String mobName, int rate) {
        this.id = id;
        this.mobName = mobName;
        this.rate = rate;
    }

    public void addBiomeFilter(IBiomeFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public List<IBiomeFilter> getFilters() {
        return this.filters;
    }

    public void addDimensionFilter(DimensionFilter filter) {
        this.dimFilters.add(filter);
    }

    @Override
    public EnumCreatureType getCreatureType() {
        return this.creatureType;
    }

    public void setCreatureType(EnumCreatureType creatureType) {
        this.creatureType = creatureType;
    }

    @Override
    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public void setMinGroupSize(int minGroupSize) {
        this.minGroupSize = minGroupSize;
    }

    @Override
    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public void setMaxGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    @Override
    public boolean isRemove() {
        return this.isRemove;
    }

    public void setIsRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMobName() {
        return this.mobName;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public boolean canSpawnInDimension(World world) {
        for (DimensionFilter f : this.dimFilters) {
            if (f.canSpawnInDimension(world)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SpawnEntry [id=" + this.id + ", mobName=" + this.mobName + ", rate=" + this.rate + ", creatureType=" + this.creatureType + ", minGroupSize=" + this.minGroupSize + ", maxGroupSize=" + this.maxGroupSize + ", isRemove=" + this.isRemove + ", filter=" + this.filters + "]";
    }
}

