/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.spawn.impl;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.spawn.IBiomeDescriptor;
import crazypants.enderzoo.spawn.IBiomeFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public abstract class AbstractBiomeFilter
implements IBiomeFilter {
    protected final List<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
    protected final List<BiomeDictionary.Type> typeExcludes = new ArrayList<BiomeDictionary.Type>();
    protected final List<ResourceLocation> names = new ArrayList<ResourceLocation>();
    protected final List<ResourceLocation> nameExcludes = new ArrayList<ResourceLocation>();

    @Override
    public void addBiomeDescriptor(IBiomeDescriptor biome) {
        if (biome.getType() != null) {
            if (biome.isExclude()) {
                this.typeExcludes.add(biome.getType());
            } else {
                this.types.add(biome.getType());
            }
        } else if (biome.getRegistryName() != null) {
            if (biome.isExclude()) {
                this.nameExcludes.add(biome.getRegistryName());
            } else {
                this.names.add(biome.getRegistryName());
            }
        }
    }

    protected boolean isExcluded(Biome candidate) {
        for (BiomeDictionary.Type exType : this.typeExcludes) {
            if (!BiomeDictionary.hasType((Biome)candidate, (BiomeDictionary.Type)exType)) continue;
            if (Config.spawnConfigPrintDetailedOutput) {
                System.out.print("Excluded " + candidate.func_185359_l() + ", ");
            }
            return true;
        }
        for (ResourceLocation exName : this.nameExcludes) {
            if (exName == null || !exName.equals((Object)candidate.getRegistryName())) continue;
            System.out.print("Excluded " + candidate.getRegistryName() + ", ");
            return false;
        }
        return false;
    }
}

