/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.vec.Point3i;
import crazypants.enderzoo.vec.VecUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class SpawnUtil {
    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation) {
        return SpawnUtil.findClearGround(world, startingLocation, clearLocation, 2, 10, false);
    }

    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation, int horizRange, int vertRange, boolean checkForLivingEntities) {
        boolean foundTargetSpace = false;
        for (int xOff = -horizRange; xOff <= horizRange && !foundTargetSpace; ++xOff) {
            clearLocation.x = startingLocation.x + xOff;
            for (int zOff = -horizRange; zOff <= horizRange && !foundTargetSpace; ++zOff) {
                clearLocation.z = startingLocation.z + zOff;
                foundTargetSpace = SpawnUtil.seachYForClearGround(clearLocation, world, vertRange, checkForLivingEntities);
                if (foundTargetSpace) continue;
                clearLocation.y = startingLocation.y;
            }
        }
        return foundTargetSpace;
    }

    public static boolean seachYForClearGround(Point3i target, World world) {
        return SpawnUtil.seachYForClearGround(target, world, 10, false);
    }

    public static boolean seachYForClearGround(Point3i target, World world, int searchRange, boolean checkForLivingEntities) {
        boolean foundY = false;
        for (int i = 0; i < searchRange && !foundY; ++i) {
            if (world.func_175623_d(VecUtil.bpos(target.x, target.y, target.z))) {
                foundY = true;
                continue;
            }
            ++target.y;
        }
        boolean onGround = false;
        if (foundY) {
            for (int i = 0; i < searchRange && !onGround; ++i) {
                boolean bl = onGround = !world.func_175623_d(VecUtil.bpos(target.x, target.y - 1, target.z)) && !SpawnUtil.isLiquid(world, target.x, target.y - 1, target.z);
                if (!onGround) {
                    --target.y;
                    continue;
                }
                if (!checkForLivingEntities || !SpawnUtil.containsLiving(world, target)) continue;
                return false;
            }
        }
        return foundY && onGround;
    }

    public static boolean containsLiving(World world, Point3i blockCoord) {
        AxisAlignedBB bb = new AxisAlignedBB((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, (double)(blockCoord.x + 1), (double)(blockCoord.y + 1), (double)(blockCoord.z + 1));
        List ents = world.func_72872_a(EntityLivingBase.class, bb);
        return ents != null && !ents.isEmpty();
    }

    public static boolean isLiquid(World world, int x, int y, int z) {
        IBlockState bs = world.func_180495_p(VecUtil.bpos(x, y, z));
        if (bs == null || bs.func_177230_c() == null) {
            return false;
        }
        return bs.func_185904_a().func_76224_d();
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, EntityCreature asCreature, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        if (asCreature != null && asCreature.func_180484_a(entity.func_180425_c()) < 0.0f) {
            return false;
        }
        if (checkEntityCollisions && !worldObj.func_72855_b(entity.func_174813_aQ())) {
            return false;
        }
        if (!worldObj.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return canSpawnInLiquid || !worldObj.func_72953_d(entity.func_174813_aQ());
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityCreature entityCreature, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, (EntityLiving)entityCreature, entityCreature, checkEntityCollisions, false);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, entity, entity instanceof EntityCreature ? (EntityCreature)entity : null, checkEntityCollisions, canSpawnInLiquid);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving spawn, boolean checkEntityCollisions) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, spawn, checkEntityCollisions, false);
    }
}

