/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo;

import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.enchantment.EnchantmentWitherArrow;
import crazypants.enderzoo.enchantment.EnchantmentWitherWeapon;
import crazypants.enderzoo.entity.EntityOwl;
import crazypants.enderzoo.entity.MobInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHandler {
    public static final List<Item> ITEMS = new ArrayList<Item>();
    public static final List<Block> BLOCKS = new ArrayList<Block>();

    @SubscribeEvent
    public void onBlockRegister(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new Block[BLOCKS.size()]));
    }

    @SubscribeEvent
    public void onItemRegister(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS.toArray(new Item[ITEMS.size()]));
    }

    @SubscribeEvent
    public void onPotionTypeRegister(RegistryEvent.Register<PotionType> e) {
        EnderZoo.potions.registerPotions((IForgeRegistry<PotionType>)e.getRegistry());
    }

    @SubscribeEvent
    public void onPotionRegister(RegistryEvent.Register<Potion> e) {
        e.getRegistry().register((IForgeRegistryEntry)EnderZoo.potions.getFloatingPotion());
    }

    @SubscribeEvent
    public void onSoundEventRegister(RegistryEvent.Register<SoundEvent> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)EntityOwl.SND_HOOT);
        reg.register((IForgeRegistryEntry)EntityOwl.SND_HOOT2);
        reg.register((IForgeRegistryEntry)EntityOwl.SND_HURT);
    }

    @SubscribeEvent
    public void onEntityRegister(RegistryEvent.Register<EntityEntry> e) {
        for (MobInfo mob : MobInfo.values()) {
            EntityEntry entry = new EntityEntry(mob.getClz(), mob.getName());
            ResourceLocation name = new ResourceLocation("enderzoo", mob.getName());
            entry.setRegistryName(name);
            entry.setEgg(new EntityList.EntityEggInfo(name, mob.getEggBackgroundColor(), mob.getEggForegroundColor()));
            e.getRegistry().register((IForgeRegistryEntry)entry);
            this.registerEntity(mob);
        }
    }

    private void registerEntity(MobInfo mob) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("enderzoo", mob.getName()), mob.getClz(), (String)mob.getName(), (int)mob.getEntityId(), (Object)EnderZoo.instance, (int)64, (int)3, (boolean)true);
    }

    @SubscribeEvent
    public void onRecipeRegister(RegistryEvent.Register<IRecipe> e) {
        EnderZoo.addRecipes();
    }

    @SubscribeEvent
    public void onEnchantmentRegister(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register((IForgeRegistryEntry)new EnchantmentWitherArrow());
        e.getRegistry().register((IForgeRegistryEntry)new EnchantmentWitherWeapon());
    }
}

