/*
 * Decompiled with CFR 0.152.
 */
package xyz.ajp.makezoomzoom.asmreimpl.forestry.factory.recipes.jei.bottler;

import forestry.factory.recipes.jei.bottler.BottlerRecipeWrapper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mezz.jei.api.ingredients.IIngredientRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xyz.ajp.makezoomzoom.MZZThreadFactory;

public class BottlerRecipeMaker {
    private static ExecutorService executorService = Executors.newCachedThreadPool(new MZZThreadFactory("JEI Forestry Bottler"));

    public static List<BottlerRecipeWrapper> getBottlerRecipes(IIngredientRegistry ingredientRegistry) {
        ArrayDeque<Future<List<BottlerRecipeWrapper>>> wrapperFutures = new ArrayDeque<Future<List<BottlerRecipeWrapper>>>(64);
        ArrayList<BottlerRecipeWrapper> recipes = new ArrayList<BottlerRecipeWrapper>();
        for (final ItemStack stack : ingredientRegistry.getAllIngredients(ItemStack.class)) {
            wrapperFutures.add(executorService.submit(new Callable<List<BottlerRecipeWrapper>>(){

                @Override
                public List<BottlerRecipeWrapper> call() throws Exception {
                    IFluidHandlerItem fluidHandler;
                    ArrayList<BottlerRecipeWrapper> retList = new ArrayList<BottlerRecipeWrapper>(2);
                    if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidHandler = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                        FluidStack drainedFluid;
                        boolean canDrain = BottlerRecipeMaker.canDrain((IFluidHandler)fluidHandler);
                        boolean canFill = BottlerRecipeMaker.canFill((IFluidHandler)fluidHandler);
                        if (canDrain && (drainedFluid = fluidHandler.drain(Integer.MAX_VALUE, true)) != null) {
                            ItemStack drained = fluidHandler.getContainer();
                            retList.add(new BottlerRecipeWrapper(stack, drainedFluid, drained, false));
                        }
                        if (canFill) {
                            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                                IFluidHandlerItem fillingCapability = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                                if (fillingCapability == null) break;
                                int fill = fillingCapability.fill(new FluidStack(fluid, Integer.MAX_VALUE), true);
                                if (fill <= 0) continue;
                                FluidStack filledFluid = new FluidStack(fluid, fill);
                                ItemStack filled = fillingCapability.getContainer();
                                retList.add(new BottlerRecipeWrapper(stack, filledFluid, filled, true));
                            }
                        }
                    }
                    return retList;
                }
            }));
            if (wrapperFutures.size() != 64) continue;
            try {
                List list = (List)((Future)wrapperFutures.remove()).get();
                recipes.addAll(list);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        while (!wrapperFutures.isEmpty()) {
            try {
                List list = (List)((Future)wrapperFutures.remove()).get();
                recipes.addAll(list);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return recipes;
    }

    private static boolean canDrain(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) continue;
            return true;
        }
        return false;
    }

    private static boolean canFill(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canFill()) continue;
            return true;
        }
        return false;
    }
}

