/*
 * Decompiled with CFR 0.152.
 */
package xyz.ajp.makezoomzoom.asmreimpl.cofh.thermalexpansion.plugins.jei.machine.transposer;

import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xyz.ajp.makezoomzoom.MZZThreadFactory;

public class TransposerRecipeCategoryExtract {
    private static ExecutorService executorService = Executors.newCachedThreadPool(new MZZThreadFactory("JEI CoFH Transposer Extract"));

    public static List<TransposerRecipeWrapper> getRecipes(IGuiHelper guiHelper, IIngredientRegistry ingredientRegistry) {
        ArrayDeque<Future<TransposerRecipeWrapper>> wrapperFutures = new ArrayDeque<Future<TransposerRecipeWrapper>>(64);
        ArrayList<TransposerRecipeWrapper> recipes = new ArrayList<TransposerRecipeWrapper>();
        for (TransposerManager.TransposerRecipe recipe : TransposerManager.getExtractRecipeList()) {
            recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_extract"));
        }
        List ingredients = ingredientRegistry.getIngredients(ItemStack.class);
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                wrapperFutures.add(TransposerRecipeCategoryExtract.addExtractRecipe(ingredient, fluid, recipes, guiHelper));
                if (wrapperFutures.size() != 64) continue;
                try {
                    TransposerRecipeWrapper recipe = (TransposerRecipeWrapper)((Future)wrapperFutures.remove()).get();
                    if (recipe == null) continue;
                    recipes.add(recipe);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        while (!wrapperFutures.isEmpty()) {
            try {
                TransposerRecipeWrapper recipe = (TransposerRecipeWrapper)((Future)wrapperFutures.remove()).get();
                if (recipe == null) continue;
                recipes.add(recipe);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return recipes;
    }

    private static Future<TransposerRecipeWrapper> addExtractRecipe(ItemStack baseStack, Fluid fluid, List<TransposerRecipeWrapper> recipes, IGuiHelper guiHelper) {
        return executorService.submit(() -> {
            ItemStack filledStack = baseStack.func_77946_l();
            IFluidHandlerItem handler = (IFluidHandlerItem)filledStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            int fill = handler.fill(new FluidStack(fluid, 1000), true);
            if (fill > 0) {
                filledStack = handler.getContainer().func_77946_l();
                FluidStack drainedFluid = handler.drain(1000, true);
                if (drainedFluid != null) {
                    ItemStack drainedStack;
                    TransposerManager.TransposerRecipe recipe = new TransposerManager.TransposerRecipe(filledStack, drainedStack, drainedFluid, 400, (drainedStack = handler.getContainer()).func_190916_E() <= 0 ? 0 : 100);
                    return new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_extract");
                }
            }
            return null;
        });
    }
}

