/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.AnimationProperty;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.animation.types.attack.AttackAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSExecuteSkill;
import maninthehouse.epicfight.network.server.STCResetBasicAttackCool;
import maninthehouse.epicfight.skill.Skill;
import maninthehouse.epicfight.skill.SkillSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpecialAttackSkill
extends Skill {
    protected final StaticAnimation attackAnimation;
    protected Map<AnimationProperty<?>, Object> propertyMap = new HashMap();

    public SpecialAttackSkill(SkillSlot index, float restriction, String skillName, StaticAnimation animation) {
        this(index, restriction, 0, skillName, animation);
    }

    public SpecialAttackSkill(SkillSlot index, float restriction, int duration, String skillName, StaticAnimation animation) {
        super(index, restriction, duration, true, skillName);
        this.attackAnimation = animation;
    }

    @Override
    public void executeOnClient(ClientPlayerData executer, PacketBuffer args) {
        ModNetworkManager.sendToServer(new CTSExecuteSkill(this.slot.getIndex(), true, args));
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.playAnimationSynchronize(this.attackAnimation, 0.0f);
        ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
    }

    @Override
    public float getRegenTimePerTick(PlayerData<?> player) {
        return 0.0f;
    }

    @Override
    public boolean canExecute(PlayerData<?> executer) {
        CapabilityItem item = executer.getHeldItemCapability(EnumHand.MAIN_HAND);
        if (item != null) {
            Skill skill = item.getSpecialAttack(executer);
            return skill == this && ((EntityPlayer)executer.getOriginalEntity()).func_184187_bx() == null;
        }
        return false;
    }

    @Override
    public boolean isExecutableState(PlayerData<?> executer) {
        LivingData.EntityState playerState = executer.getEntityState();
        return !((EntityPlayer)executer.getOriginalEntity()).func_184613_cA() && executer.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ITextComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(new TextComponentTranslation("skill.epicfight." + this.registryName.func_110623_a(), new Object[0]).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + String.format("[%.0f]", Float.valueOf(this.cooldown)))));
        list.add(new TextComponentTranslation(TextFormatting.DARK_GRAY + "skill." + "epicfight" + "." + this.registryName.func_110623_a() + "_tooltip", new Object[0]));
        StringBuilder damageFormat = new StringBuilder("");
        if (this.propertyMap.containsKey(AnimationProperty.DAMAGE_MULTIPLIER)) {
            damageFormat.append(String.format("%.0f%%", Float.valueOf(this.getProperty(AnimationProperty.DAMAGE_MULTIPLIER).floatValue() * 100.0f)));
        } else {
            damageFormat.append("100%");
        }
        if (this.propertyMap.containsKey(AnimationProperty.DAMAGE_ADDER)) {
            damageFormat.append(String.format(" + %.0f", this.getProperty(AnimationProperty.DAMAGE_ADDER)));
        }
        damageFormat.append(TextFormatting.DARK_GRAY + " damage");
        list.add(new TextComponentString(TextFormatting.DARK_RED + damageFormat.toString()));
        if (this.propertyMap.containsKey(AnimationProperty.IMPACT)) {
            list.add(new TextComponentString(String.format(TextFormatting.GOLD + "%.1f" + TextFormatting.DARK_GRAY + " impact", this.getProperty(AnimationProperty.IMPACT))));
        }
        if (this.propertyMap.containsKey(AnimationProperty.ARMOR_NEGATION)) {
            list.add(new TextComponentString(String.format(TextFormatting.GOLD + "%.0f%%" + TextFormatting.DARK_GRAY + " armor negation", this.getProperty(AnimationProperty.ARMOR_NEGATION))));
        }
        if (this.propertyMap.containsKey(AnimationProperty.HIT_AT_ONCE)) {
            list.add(new TextComponentString(String.format(TextFormatting.DARK_GRAY + "hit" + TextFormatting.WHITE + " %d " + TextFormatting.DARK_GRAY + "enemies", this.getProperty(AnimationProperty.HIT_AT_ONCE))));
        }
        if (this.propertyMap.containsKey(AnimationProperty.STUN_TYPE)) {
            list.add(new TextComponentString(TextFormatting.DARK_GRAY + "apply " + this.getProperty(AnimationProperty.STUN_TYPE).toString()));
        }
        return list;
    }

    protected <T> T getProperty(AnimationProperty<T> propertyType) {
        return (T)this.propertyMap.get(propertyType);
    }

    public <T> SpecialAttackSkill addProperty(AnimationProperty<T> attribute, T object) {
        this.propertyMap.put(attribute, object);
        return this;
    }

    public SpecialAttackSkill registerPropertiesToAnimation() {
        ((AttackAnimation)this.attackAnimation).addProperties(this.propertyMap.entrySet());
        return this;
    }
}

