/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.client.events.engine.ControllEngine;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCSetSkillValue;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.game.Formulars;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Skill {
    protected ResourceLocation registryName;
    protected final SkillSlot slot;
    protected final boolean isActiveSkill;
    protected final float cooldown;
    protected final int duration;
    protected final int maxStackSize;

    public Skill(SkillSlot index, float cooldown, String skillName) {
        this(index, cooldown, 0, 1, true, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int maxStack, String skillName) {
        this(index, cooldown, 0, maxStack, true, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int duration, boolean isActiveSkill, String skillName) {
        this(index, cooldown, duration, 1, true, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int duration, int maxStack, boolean isActiveSkill, String skillName) {
        this.cooldown = cooldown;
        this.duration = duration;
        this.isActiveSkill = isActiveSkill;
        this.slot = index;
        this.maxStackSize = maxStack;
        this.registryName = new ResourceLocation("epicfight", skillName);
    }

    public PacketBuffer gatherArguments(ClientPlayerData executer, ControllEngine controllEngine) {
        return null;
    }

    public boolean isExecutableState(PlayerData<?> executer) {
        LivingData.EntityState playerState = executer.getEntityState();
        return !((EntityPlayer)executer.getOriginalEntity()).func_184613_cA() && executer.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    public boolean canExecute(PlayerData<?> executer) {
        return true;
    }

    public void executeOnClient(ClientPlayerData executer, PacketBuffer args) {
    }

    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        this.setDurationSynchronize(executer, this.duration);
    }

    public void cancelOnClient(ClientPlayerData executer, PacketBuffer args) {
    }

    public void execute(SkillContainer container) {
        container.duration = this.duration;
        container.isActivated = true;
    }

    public void onInitiate(SkillContainer container) {
    }

    public void onDeleted(SkillContainer container) {
    }

    public void onReset(SkillContainer container) {
    }

    public void setCooldown(SkillContainer container, float value) {
        container.cooldown = value;
        container.cooldown = Math.max(container.cooldown, 0.0f);
        container.cooldown = Math.min(container.cooldown, this.cooldown);
        if (value >= this.cooldown) {
            if (container.stack < this.maxStackSize) {
                ++container.stack;
                if (container.stack < this.maxStackSize) {
                    container.cooldown = 0.0f;
                    container.prevCooldown = 0.0f;
                }
            } else {
                container.cooldown = this.cooldown;
                container.prevCooldown = this.cooldown;
            }
        } else if (value == 0.0f && container.stack > 0) {
            --container.stack;
        }
    }

    public void update(SkillContainer container) {
        PlayerData<?> executer = container.executer;
        container.prevCooldown = container.cooldown;
        container.prevDuration = container.duration;
        if (container.stack < container.containingSkill.maxStackSize) {
            container.setCooldown(container.cooldown + this.getRegenTimePerTick(executer) * 0.05f);
        }
        if (container.isActivated) {
            if (container.consumeDuration) {
                --container.duration;
            }
            if (container.duration <= 0) {
                if (container.executer.isRemote()) {
                    container.containingSkill.cancelOnClient((ClientPlayerData)executer, null);
                } else {
                    container.containingSkill.cancelOnServer((ServerPlayerData)executer, null);
                }
                container.isActivated = false;
                container.duration = 0;
            }
        }
    }

    public void cancelOnServer(ServerPlayerData executer, PacketBuffer args) {
        this.setCooldownSynchronize(executer, 0.0f);
    }

    public void setCooldownSynchronize(ServerPlayerData executer, float amount) {
        Skill.setCooldownSynchronize(executer, this.slot, amount);
    }

    public void setDurationSynchronize(ServerPlayerData executer, int amount) {
        Skill.setDurationSynchronize(executer, this.slot, amount);
    }

    public void setDurationConsumeSynchronize(ServerPlayerData executer, boolean bool) {
        Skill.setDurationConsumeSynchronize(executer, this.slot, bool);
    }

    public static void setCooldownSynchronize(ServerPlayerData executer, SkillSlot slot, float amount) {
        if (amount > 0.0f) {
            executer.getSkill(slot).setCooldown(amount);
        } else {
            executer.getSkill(slot).reset(!executer.getOriginalEntity().func_184812_l_());
        }
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.COOLDOWN, slot.index, amount, false), executer.getOriginalEntity());
    }

    public static void setDurationSynchronize(ServerPlayerData executer, SkillSlot slot, int amount) {
        executer.getSkill(slot).setDuration(amount);
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.DURATION, slot.index, (float)amount, false), executer.getOriginalEntity());
    }

    public static void setDurationConsumeSynchronize(ServerPlayerData executer, SkillSlot slot, boolean bool) {
        executer.getSkill(slot).setDurationConsume(bool);
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.DURATION_CONSUME, slot.index, 0.0f, bool), executer.getOriginalEntity());
    }

    @SideOnly(value=Side.CLIENT)
    public List<ITextComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public float getRegenTimePerTick(PlayerData<?> player) {
        return Formulars.getSkillRegen((float)player.getWeight(), player);
    }

    public SkillSlot getSlot() {
        return this.slot;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public boolean isActiveSkill() {
        return this.isActiveSkill;
    }
}

