/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.network.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCLivingMotionChange;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CTSReqPlayerInfo
implements IMessage {
    private int entityId;

    public CTSReqPlayerInfo() {
        this.entityId = 0;
    }

    public CTSReqPlayerInfo(int entityId) {
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public static class Handler
    implements IMessageHandler<CTSReqPlayerInfo, IMessage> {
        public IMessage onMessage(CTSReqPlayerInfo message, MessageContext ctx) {
            EntityPlayerMP playerMP = ctx.getServerHandler().field_147369_b;
            playerMP.func_71121_q().func_152344_a(() -> {
                ServerPlayerData playerdata = (ServerPlayerData)playerMP.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                if (playerdata != null) {
                    ArrayList motions = Lists.newArrayList();
                    ArrayList animations = Lists.newArrayList();
                    int i = 0;
                    for (Map.Entry<LivingMotion, StaticAnimation> entry : playerdata.getLivingMotionEntrySet()) {
                        motions.add(entry.getKey());
                        animations.add(entry.getValue());
                        ++i;
                    }
                    LivingMotion[] motionarr = motions.toArray(new LivingMotion[0]);
                    StaticAnimation[] animationarr = animations.toArray(new StaticAnimation[0]);
                    STCLivingMotionChange mg = new STCLivingMotionChange(playerdata.getOriginalEntity().func_145782_y(), i);
                    mg.setMotions(motionarr);
                    mg.setAnimations(animationarr);
                    ModNetworkManager.sendToPlayer(mg, playerMP);
                }
            });
            return null;
        }
    }
}

