/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.events;

import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCGameruleChange;
import maninthehouse.epicfight.utils.game.Formulars;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="epicfight")
public class WorldEvents {
    @SubscribeEvent
    public static void loadWorldEvent(WorldEvent.Load event) {
        GameRules gameRule = event.getWorld().func_72912_H().func_82574_x();
        if (!gameRule.func_82765_e("doVanillaAttack")) {
            gameRule.func_180262_a("doVanillaAttack", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!gameRule.func_82765_e("hasFallAnimation")) {
            gameRule.func_180262_a("hasFallAnimation", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!gameRule.func_82765_e("speedPenaltyPercent")) {
            gameRule.func_180262_a("speedPenaltyPercent", "100", GameRules.ValueType.NUMERICAL_VALUE);
        }
    }

    @SubscribeEvent
    public static void gameruleChangeEvent(GameRuleChangeEvent event) {
        if (event.getRuleName().equals("hasFallAnimation")) {
            ModNetworkManager.sendToAll(new STCGameruleChange(event.getRuleName(), event.getRules().func_82767_a(event.getRuleName())));
        }
        if (event.getRuleName().equals("speedPenaltyPercent")) {
            for (EntityPlayerMP player : event.getServer().func_184103_al().func_181057_v()) {
                ServerPlayerData playerdata = (ServerPlayerData)player.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                if (playerdata == null) continue;
                IAttributeInstance mainhandAttackSpeed = playerdata.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f);
                IAttributeInstance offhandAttackSpeed = playerdata.getOriginalEntity().func_110140_aT().func_111151_a(ModAttributes.OFFHAND_ATTACK_SPEED);
                mainhandAttackSpeed.func_188479_b(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER);
                float mainWeaponSpeed = (float)mainhandAttackSpeed.func_111125_b();
                for (AttributeModifier attributeModifier : playerdata.getOriginalEntity().func_184614_ca().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                    mainWeaponSpeed += (float)attributeModifier.func_111164_d();
                }
                mainhandAttackSpeed.func_111121_a(new AttributeModifier(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(playerdata.getWeight(), mainWeaponSpeed, playerdata), 0));
                offhandAttackSpeed.func_188479_b(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER);
                float offWeaponSpeed = (float)offhandAttackSpeed.func_111125_b();
                for (AttributeModifier attributeModifier : playerdata.getOriginalEntity().func_184592_cb().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                    offWeaponSpeed += (float)attributeModifier.func_111164_d();
                }
                offhandAttackSpeed.func_111121_a(new AttributeModifier(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(playerdata.getWeight(), offWeaponSpeed, playerdata), 0));
            }
            ModNetworkManager.sendToAll(new STCGameruleChange(event.getRuleName(), event.getRules().func_82767_a(event.getRuleName())));
        }
    }

    @SubscribeEvent
    public static void playerLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        GameRules gamerules = event.player.field_70170_p.func_82736_K();
        ModNetworkManager.sendToPlayer(new STCGameruleChange("hasFallAnimation", gamerules.func_82767_a("hasFallAnimation")), (EntityPlayerMP)event.player);
        ModNetworkManager.sendToPlayer(new STCGameruleChange("speedPenaltyPercent", gamerules.func_82767_a("speedPenaltyPercent")), (EntityPlayerMP)event.player);
    }
}

