/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.entity.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.UUID;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.entity.event.PlayerEvent;

public class EntityEventListener {
    private Multimap<Event, PlayerEvent> map;
    private final PlayerData<?> player;

    public EntityEventListener(PlayerData<?> player) {
        this.player = player;
        this.map = HashMultimap.create();
    }

    public void addEventListener(Event event, PlayerEvent function) {
        this.map.put((Object)event, (Object)function);
    }

    public void removeListener(Event event, UUID functionUUID) {
        Collection c = this.map.get((Object)event);
        PlayerEvent wantToRemove = null;
        for (PlayerEvent e : c) {
            if (!e.is(functionUUID)) continue;
            wantToRemove = e;
            break;
        }
        if (wantToRemove != null) {
            c.remove(wantToRemove);
        }
    }

    public boolean activateEvents(Event event) {
        boolean cancel = false;
        for (PlayerEvent function : this.map.get((Object)event)) {
            if (event.isRemote != this.player.isRemote()) continue;
            cancel |= function.doIt(this.player);
        }
        return cancel;
    }

    public static enum Event {
        ON_ACTION_SERVER_EVENT(false),
        ON_ATTACK_CLIENT_EVENT(true);

        boolean isRemote;

        private Event(boolean isRemote) {
            this.isRemote = isRemote;
        }

        public boolean getDist() {
            return this.isRemote;
        }
    }
}

