/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.collada.xml;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import maninthehouse.epicfight.collada.xml.XmlNode;

public class XmlParser {
    private static final Pattern DATA = Pattern.compile(">(.+?)<");
    private static final Pattern START_TAG = Pattern.compile("<(.+?)>");
    private static final Pattern ATTR_NAME = Pattern.compile("(.+?)=");
    private static final Pattern ATTR_VAL = Pattern.compile("\"(.+?)\"");
    private static final Pattern CLOSED = Pattern.compile("(</|/>)");

    public static XmlNode loadXmlFile(BufferedReader bufferedReader) {
        try {
            bufferedReader.readLine();
            XmlNode node = XmlParser.loadNode(bufferedReader);
            bufferedReader.close();
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error with XML file format");
            return null;
        }
    }

    private static XmlNode loadNode(BufferedReader reader) throws Exception {
        String line = reader.readLine().trim();
        if (line.startsWith("</")) {
            return null;
        }
        String[] startTagParts = XmlParser.getStartTag(line).split(" ");
        XmlNode node = new XmlNode(startTagParts[0].replace("/", ""));
        XmlParser.addAttributes(startTagParts, node);
        XmlParser.addData(line, node);
        if (CLOSED.matcher(line).find()) {
            return node;
        }
        XmlNode child = null;
        while ((child = XmlParser.loadNode(reader)) != null) {
            node.addChild(child);
        }
        return node;
    }

    private static void addData(String line, XmlNode node) {
        Matcher matcher = DATA.matcher(line);
        if (matcher.find()) {
            node.setData(matcher.group(1));
        }
    }

    private static void addAttributes(String[] titleParts, XmlNode node) {
        for (int i = 1; i < titleParts.length; ++i) {
            if (!titleParts[i].contains("=")) continue;
            XmlParser.addAttribute(titleParts[i], node);
        }
    }

    private static void addAttribute(String attributeLine, XmlNode node) {
        Matcher nameMatch = ATTR_NAME.matcher(attributeLine);
        nameMatch.find();
        Matcher valMatch = ATTR_VAL.matcher(attributeLine);
        valMatch.find();
        node.addAttribute(nameMatch.group(1), valMatch.group(1));
    }

    private static String getStartTag(String line) {
        Matcher match = START_TAG.matcher(line);
        match.find();
        return match.group(1);
    }
}

