/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.renderer.layer;

import java.util.HashMap;
import java.util.Map;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.item.ArmorCapability;
import maninthehouse.epicfight.client.ClientEngine;
import maninthehouse.epicfight.client.model.ClientModel;
import maninthehouse.epicfight.client.model.custom.CustomModelBakery;
import maninthehouse.epicfight.client.renderer.layer.Layer;
import maninthehouse.epicfight.main.EpicFightMod;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WearableItemLayer<E extends EntityLivingBase, T extends LivingData<E>>
extends Layer<E, T> {
    private static final Map<ResourceLocation, ClientModel> ARMOR_MODEL_MAP = new HashMap<ResourceLocation, ClientModel>();
    private static final Map<ModelBiped, ClientModel> ARMOR_MODEL_MAP_BY_MODEL = new HashMap<ModelBiped, ClientModel>();
    private static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final EntityEquipmentSlot slot;

    public WearableItemLayer(EntityEquipmentSlot slotType) {
        this.slot = slotType;
    }

    @Override
    public void renderLayer(T entitydata, E entityliving, VisibleMatrix4f[] poses, float partialTicks) {
        ItemStack stack = entityliving.func_184582_a(this.slot);
        Item item = stack.func_77973_b();
        GlStateManager.func_179094_E();
        if (this.slot == EntityEquipmentSlot.HEAD && entityliving instanceof EntityZombieVillager) {
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
        }
        if (item instanceof ItemArmor) {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            ItemArmor armorItem = (ItemArmor)stack.func_77973_b();
            ClientModel model = this.getArmorModel(entityliving, armorItem, stack);
            boolean hasOverlay = armorItem.hasOverlay(stack);
            textureManager.func_110577_a(this.getArmorTexture(stack, (Entity)entityliving, armorItem.func_185083_B_(), null));
            if (hasOverlay) {
                int i = armorItem.func_82814_b(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(1.0f * r), (float)(1.0f * g), (float)(1.0f * b), (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderArmor(model, poses);
            if (hasOverlay) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                textureManager.func_110577_a(this.getArmorTexture(stack, (Entity)entityliving, armorItem.func_185083_B_(), "overlay"));
                this.renderArmor(model, poses);
            }
            if (stack.func_77962_s()) {
                this.renderEnchantedGlint((EntityLivingBase)entityliving, model, partialTicks, poses);
            }
        } else if (item != Items.field_190931_a) {
            ClientEngine.INSTANCE.renderEngine.getItemRenderer(stack.func_77973_b()).renderItemOnHead(stack, (LivingData<?>)entitydata, partialTicks);
        }
        GlStateManager.func_179121_F();
    }

    private ClientModel getArmorModel(E entityliving, ItemArmor armorItem, ItemStack stack) {
        ClientModel model;
        ResourceLocation registryName = armorItem.getRegistryName();
        if (ARMOR_MODEL_MAP.containsKey(registryName)) {
            return ARMOR_MODEL_MAP.get(registryName);
        }
        ModelBiped originalModel = new ModelBiped(0.5f);
        RenderLivingBase entityRenderer = (RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().func_78713_a(entityliving);
        for (LayerRenderer layer : entityRenderer.field_177097_h) {
            if (!(layer instanceof LayerArmorBase)) continue;
            originalModel = (ModelBiped)((LayerArmorBase)layer).func_188360_a(this.slot);
        }
        ModelBiped customModel = armorItem.getArmorModel(entityliving, stack, this.slot, originalModel);
        if (customModel == null) {
            ArmorCapability cap = (ArmorCapability)stack.getCapability(ModCapabilities.CAPABILITY_ITEM, null);
            ClientModel model2 = cap == null ? ArmorCapability.getBipedArmorModel(armorItem.func_185083_B_()) : cap.getArmorModel(armorItem.func_185083_B_());
            ARMOR_MODEL_MAP.put(registryName, model2);
            return model2;
        }
        if (ARMOR_MODEL_MAP_BY_MODEL.containsKey(customModel)) {
            model = ARMOR_MODEL_MAP_BY_MODEL.get(customModel);
        } else {
            EpicFightMod.LOGGER.info("baked new model for " + registryName);
            model = CustomModelBakery.bakeBipedCustomArmorModel(customModel, armorItem);
        }
        ARMOR_MODEL_MAP.put(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EntityEquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = (ResourceLocation)LayerBipedArmor.field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            LayerBipedArmor.field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private void renderArmor(ClientModel model, VisibleMatrix4f[] poses) {
        model.draw(poses);
    }

    private void renderEnchantedGlint(EntityLivingBase entityIn, ClientModel model, float partialTicks, VisibleMatrix4f[] poses) {
        float f = (float)entityIn.field_70173_aa + partialTicks;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ENCHANTED_ITEM_GLINT_RES);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179152_a((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            model.draw(poses);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
    }
}

