/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.renderer.entity;

import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.util.List;
import maninthehouse.epicfight.animation.AnimationPlayer;
import maninthehouse.epicfight.animation.Joint;
import maninthehouse.epicfight.animation.types.attack.AttackAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.client.model.ClientModel;
import maninthehouse.epicfight.client.model.ClientModels;
import maninthehouse.epicfight.client.renderer.layer.Layer;
import maninthehouse.epicfight.model.Armature;
import maninthehouse.epicfight.physics.Collider;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ArmatureRenderer<E extends EntityLivingBase, T extends LivingData<E>> {
    protected List<Layer<E, T>> layers = Lists.newArrayList();

    public void render(E entityIn, T entitydata, RenderLivingBase<E> renderer, double x, double y, double z, float partialTicks) {
        AnimatorClient animator;
        AnimationPlayer player;
        renderer.func_177067_a(entityIn, x, y, z);
        ClientModel model = ((LivingData)entitydata).getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        GlStateManager.func_179094_E();
        this.applyRotations(armature, entityIn, entitydata, x, y, z, partialTicks);
        ((LivingData)entitydata).getClientAnimator().setPoseToModel(partialTicks);
        VisibleMatrix4f[] poses = armature.getJointTransforms();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getEntityTexture(entityIn));
        GlStateManager.func_179129_p();
        model.draw(poses);
        this.renderLayer(entitydata, entityIn, poses, partialTicks);
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && (player = (animator = ((LivingData)entitydata).getClientAnimator()).getPlayer()).getPlay() instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)player.getPlay();
            boolean flag3 = ((LivingData)entitydata).getEntityState().shouldDetectCollision();
            float elapsedTime = player.getElapsedTime();
            int index = attackAnimation.getIndexer(elapsedTime);
            Collider collider = attackAnimation.getCollider((LivingData<?>)entitydata, elapsedTime);
            VisibleMatrix4f mat = null;
            if (index > 0) {
                Joint joint = armature.getJointHierarcy();
                while (index >> 5 != 0) {
                    joint = joint.getSubJoints().get(((index >>= 5) & 0x1F) - 1);
                }
                mat = joint.getAnimatedTransform();
            }
            if (mat == null) {
                mat = new VisibleMatrix4f();
            }
            collider.draw(mat, partialTicks, flag3);
        }
        GlStateManager.func_179121_F();
    }

    protected abstract ResourceLocation getEntityTexture(E var1);

    protected void renderLayer(T entitydata, E entityIn, VisibleMatrix4f[] poses, float partialTicks) {
        for (Layer<E, T> layer : this.layers) {
            layer.renderLayer(entitydata, entityIn, poses, partialTicks);
        }
    }

    protected boolean isVisible(E entityIn) {
        return !entityIn.func_82150_aj();
    }

    protected void transformJoint(int jointId, Armature modelArmature, VisibleMatrix4f mat) {
        Joint joint = modelArmature.findJointById(jointId);
        VisibleMatrix4f.mul(joint.getAnimatedTransform(), mat, joint.getAnimatedTransform());
    }

    protected void applyRotations(Armature armature, E entityIn, T entitydata, double x, double y, double z, float partialTicks) {
        VisibleMatrix4f mat4f = ((LivingData)entitydata).getModelMatrix(partialTicks);
        mat4f.m30 = 0.0f;
        mat4f.m31 = 0.0f;
        mat4f.m32 = 0.0f;
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179110_a((FloatBuffer)mat4f.toFloatBuffer());
    }
}

