/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.gui;

import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.Iterator;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.CapabilityEntity;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.gui.EntityIndicator;
import maninthehouse.epicfight.config.ConfigurationIngame;
import maninthehouse.epicfight.effects.ModEffect;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HealthBarIndicator
extends EntityIndicator {
    @Override
    public boolean shouldDraw(EntityLivingBase entityIn) {
        if (!ConfigurationIngame.showHealthIndicator) {
            return false;
        }
        if (!entityIn.func_184222_aU() || entityIn.func_82150_aj() || entityIn == Minecraft.func_71410_x().field_71439_g.func_184187_bx()) {
            return false;
        }
        if (entityIn.func_70068_e(Minecraft.func_71410_x().func_175606_aa()) >= 400.0) {
            return false;
        }
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)entityIn;
            if (playerIn == Minecraft.func_71410_x().field_71439_g) {
                return false;
            }
            if (playerIn.func_184812_l_() || playerIn.func_175149_v()) {
                return false;
            }
        }
        return !(entityIn.func_70651_bq().isEmpty() && entityIn.func_110143_aJ() >= entityIn.func_110138_aP()) && entityIn.field_70725_aQ < 19;
    }

    @Override
    public void drawIndicator(EntityLivingBase entityIn, double x, double y, double z, float partialTicks) {
        CapabilityEntity entitycap;
        GlStateManager.func_179094_E();
        VisibleMatrix4f mvMatrix = super.setupMatrix(x, y, z, 0.0f, entityIn.field_70131_O + 0.25f, 0.0f, true, false, partialTicks);
        GlStateManager.func_179110_a((FloatBuffer)mvMatrix.toFloatBuffer());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        if (!entityIn.func_70651_bq().isEmpty()) {
            Collection activeEffects = entityIn.func_70651_bq();
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    float texmaxV;
                    float texminV;
                    float texmaxU;
                    float texminU;
                    Potion effect = ((PotionEffect)iter.next()).func_188419_a();
                    if (effect instanceof ModEffect) {
                        texminU = 0.0f;
                        texmaxU = 0.0f;
                        texminV = 256.0f;
                        texmaxV = 256.0f;
                        rl = ((ModEffect)effect).getIcon();
                    } else {
                        int i1 = effect.func_76392_e();
                        texminU = i1 % 8 * 18;
                        texmaxU = texminU + 18.0f;
                        texminV = 198 + i1 / 8 * 18;
                        texmaxV = texminV + 18.0f;
                        rl = GuiContainer.field_147001_a;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                    float screenX = startX + 0.3f * (float)j;
                    float screenY = startY + -0.3f * (float)i;
                    this.drawTexturedModalRect2DPlane(screenX, screenY, screenX + 0.3f, screenY + 0.3f, texminU, texmaxU, texminV, texmaxV);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BATTLE_ICON);
        float ratio = entityIn.func_110143_aJ() / entityIn.func_110138_aP();
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(-0.5f, -0.05f, healthRatio, 0.05f, 1.0f, 15.0f, textureRatio, 20.0f);
        this.drawTexturedModalRect2DPlane(healthRatio, -0.05f, 0.5f, 0.05f, textureRatio, 10.0f, 62.0f, 15.0f);
        float absorption = entityIn.func_110139_bj();
        if ((double)absorption > 0.0) {
            float absorptionRatio = absorption / entityIn.func_110138_aP();
            int absTexRatio = (int)(62.0f * absorptionRatio);
            this.drawTexturedModalRect2DPlane(-0.5f, -0.05f, absorptionRatio - 0.5f, 0.05f, 1.0f, 20.0f, absTexRatio, 25.0f);
        }
        if ((entitycap = (CapabilityEntity)entityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null && entitycap instanceof LivingData) {
            this.renderStunArmor((LivingData)entitycap);
        }
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179121_F();
    }

    public void renderStunArmor(LivingData<?> entitydataFighter) {
        if (entitydataFighter.getStunArmor() == 0.0f) {
            return;
        }
        float ratio = entitydataFighter.getStunArmor() / entitydataFighter.getMaxStunArmor();
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(-0.5f, -0.1f, barRatio, -0.05f, 1.0f, 5.0f, textureRatio, 10.0f);
        this.drawTexturedModalRect2DPlane(barRatio, -0.1f, 0.5f, -0.05f, textureRatio, 0.0f, 63.0f, 5.0f);
    }
}

