/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import maninthehouse.epicfight.client.ClientEngine;
import maninthehouse.epicfight.client.gui.HealthBarIndicator;
import maninthehouse.epicfight.client.gui.ModIngameGui;
import maninthehouse.epicfight.client.gui.TargetIndicator;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class EntityIndicator
extends ModIngameGui {
    public static final List<EntityIndicator> ENTITY_INDICATOR_RENDERERS = Lists.newArrayList();
    public static final ResourceLocation BATTLE_ICON = new ResourceLocation("epicfight", "textures/gui/battle_icons.png");

    public static void init() {
        new TargetIndicator();
        new HealthBarIndicator();
    }

    public void drawTexturedModalRect2DPlane(float minX, float minY, float maxX, float maxY, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        this.drawTexturedModalRect3DPlane(minX, minY, this.field_73735_i, maxX, maxY, this.field_73735_i, minTexU, minTexV, maxTexU, maxTexV);
    }

    public void drawTexturedModalRect3DPlane(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        float cor = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_187315_a((double)(minTexU * cor), (double)(maxTexV * cor)).func_181675_d();
        bufferBuilder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_187315_a((double)(maxTexU * cor), (double)(maxTexV * cor)).func_181675_d();
        bufferBuilder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_187315_a((double)(maxTexU * cor), (double)(minTexV * cor)).func_181675_d();
        bufferBuilder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_187315_a((double)(minTexU * cor), (double)(minTexV * cor)).func_181675_d();
        tessellator.func_78381_a();
    }

    public EntityIndicator() {
        ENTITY_INDICATOR_RENDERERS.add(this);
    }

    public VisibleMatrix4f setupMatrix(double x, double y, double z, float correctionX, float correctionY, float correctionZ, boolean lockRotation, boolean setupProjection, float partialTicks) {
        VisibleMatrix4f matrix = new VisibleMatrix4f();
        matrix.translate((float)x, (float)y + correctionY, (float)z);
        matrix.rotateDegree(-Minecraft.func_71410_x().func_175606_aa().field_70177_z + 180.0f, new Vec3f(0.0f, 1.0f, 0.0f));
        matrix.rotateDegree(-Minecraft.func_71410_x().func_175606_aa().field_70125_A, new Vec3f(1.0f, 0.0f, 0.0f));
        return this.setupMatrix(matrix, lockRotation, setupProjection);
    }

    public VisibleMatrix4f setupMatrix(VisibleMatrix4f matrix, boolean lockRotation, boolean setupProjection) {
        VisibleMatrix4f finalMatrix = new VisibleMatrix4f();
        VisibleMatrix4f.mul(matrix, finalMatrix, finalMatrix);
        if (setupProjection) {
            VisibleMatrix4f.mul(ClientEngine.INSTANCE.renderEngine.getCurrentProjectionMatrix(), finalMatrix, finalMatrix);
        }
        return finalMatrix;
    }

    public abstract void drawIndicator(EntityLivingBase var1, double var2, double var4, double var6, float var8);

    public abstract boolean shouldDraw(EntityLivingBase var1);
}

