/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.physics.Collider;
import maninthehouse.epicfight.skill.Skill;
import net.minecraft.util.SoundEvent;

public class ModWeaponCapability
extends CapabilityItem {
    protected final Function<LivingData<?>, CapabilityItem.WieldStyle> stylegetter;
    protected final Skill weaponGimmick;
    protected final SoundEvent smashingSound;
    protected final SoundEvent hitSound;
    protected final Collider weaponCollider;
    protected CapabilityItem.HandProperty handProperty;
    protected Map<CapabilityItem.WieldStyle, List<StaticAnimation>> autoAttackMotionMap = Maps.newHashMap();
    protected Map<CapabilityItem.WieldStyle, Skill> specialAttackMap = Maps.newHashMap();
    protected Map<LivingMotion, StaticAnimation> livingMotionChangers;

    public ModWeaponCapability(CapabilityItem.WeaponCategory category, Function<LivingData<?>, CapabilityItem.WieldStyle> stylegetter, Skill weaponGimmick, SoundEvent smash, SoundEvent hit, Collider weaponCollider, CapabilityItem.HandProperty handProperty) {
        super(category);
        this.stylegetter = stylegetter;
        this.weaponGimmick = weaponGimmick;
        this.smashingSound = smash;
        this.hitSound = hit;
        this.handProperty = handProperty;
        this.weaponCollider = weaponCollider;
    }

    public void addLivingMotionChanger(LivingMotion livingMotion, StaticAnimation animation) {
        if (this.livingMotionChangers == null) {
            this.livingMotionChangers = new HashMap<LivingMotion, StaticAnimation>();
        }
        this.livingMotionChangers.put(livingMotion, animation);
    }

    public void addStyleCombo(CapabilityItem.WieldStyle style, StaticAnimation ... animation) {
        this.autoAttackMotionMap.put(style, Lists.newArrayList((Object[])animation));
    }

    public void addStyleSpecialAttack(CapabilityItem.WieldStyle style, Skill specialAttack) {
        this.specialAttackMap.put(style, specialAttack);
    }

    @Override
    public final List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return this.autoAttackMotionMap.get((Object)this.getStyle(playerdata));
    }

    @Override
    public final Skill getSpecialAttack(PlayerData<?> playerdata) {
        return this.specialAttackMap.get((Object)this.getStyle(playerdata));
    }

    @Override
    public Skill getPassiveSkill() {
        return this.weaponGimmick;
    }

    @Override
    public final List<StaticAnimation> getMountAttackMotion() {
        return this.autoAttackMotionMap.get((Object)CapabilityItem.WieldStyle.MOUNT);
    }

    @Override
    public CapabilityItem.WieldStyle getStyle(LivingData<?> entitydata) {
        return this.stylegetter.apply(entitydata);
    }

    @Override
    public SoundEvent getSmashingSound() {
        return this.smashingSound;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public Collider getWeaponCollider() {
        return this.weaponCollider != null ? this.weaponCollider : super.getWeaponCollider();
    }

    @Override
    public CapabilityItem.HandProperty getHandProperty() {
        return this.handProperty;
    }

    @Override
    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return this.livingMotionChangers;
    }
}

