/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.model.ClientModel;
import maninthehouse.epicfight.client.model.ClientModels;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorCapability
extends CapabilityItem {
    protected static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected double weight;
    protected double stunArmor;
    private final EntityEquipmentSlot equipmentSlot;

    public ArmorCapability(Item item) {
        super(item, CapabilityItem.WeaponCategory.NONE_WEAON);
        ItemArmor armorItem = (ItemArmor)item;
        ItemArmor.ArmorMaterial armorMaterial = armorItem.func_82812_d();
        this.equipmentSlot = armorItem.field_77881_a;
        this.weight = (float)armorMaterial.func_78044_b(this.equipmentSlot) * 2.5f;
        this.stunArmor = (float)armorMaterial.func_78044_b(this.equipmentSlot) * 0.375f;
    }

    public ArmorCapability(Item item, double customWeight, double customStunArmor) {
        super(item, CapabilityItem.WeaponCategory.NONE_WEAON);
        ItemArmor armorItem = (ItemArmor)item;
        this.equipmentSlot = armorItem.field_77881_a;
        this.weight = customWeight;
        this.stunArmor = customStunArmor;
    }

    @Override
    public void modifyItemTooltip(List<String> itemTooltip, LivingData<?> entitydata) {
        itemTooltip.add(1, new TextComponentString(TextFormatting.BLUE + " +" + (int)this.weight + " ").func_150257_a((ITextComponent)new TextComponentTranslation("attribute.name.epicfight." + ModAttributes.WEIGHT.func_111108_a(), new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)).func_150254_d());
        if (this.stunArmor > 0.0) {
            itemTooltip.add(1, new TextComponentString(TextFormatting.BLUE + " +" + ItemStack.field_111284_a.format(this.stunArmor) + " ").func_150257_a((ITextComponent)new TextComponentTranslation("attribute.name.epicfight." + ModAttributes.MAX_STUN_ARMOR.func_111108_a(), new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)).func_150254_d());
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, LivingData<?> entitydata) {
        HashMultimap map = HashMultimap.create();
        if (entitydata != null && equipmentSlot == this.equipmentSlot) {
            map.put((Object)ModAttributes.WEIGHT.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.weight, 0));
            map.put((Object)ModAttributes.MAX_STUN_ARMOR.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.stunArmor, 0));
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public ClientModel getArmorModel(EntityEquipmentSlot slot) {
        return ArmorCapability.getBipedArmorModel(slot);
    }

    @SideOnly(value=Side.CLIENT)
    public static ClientModel getBipedArmorModel(EntityEquipmentSlot slot) {
        ClientModels modelDB = ClientModels.LOGICAL_CLIENT;
        switch (slot) {
            case HEAD: {
                return modelDB.ITEM_HELMET;
            }
            case CHEST: {
                return modelDB.ITEM_CHESTPLATE;
            }
            case LEGS: {
                return modelDB.ITEM_LEGGINS;
            }
            case FEET: {
                return modelDB.ITEM_BOOTS;
            }
        }
        return null;
    }
}

