/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCLivingMotionChange;
import maninthehouse.epicfight.network.server.STCNotifyPlayerYawChanged;
import maninthehouse.epicfight.network.server.STCPlayAnimation;
import maninthehouse.epicfight.network.server.STCSetSkillValue;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.game.Formulars;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class ServerPlayerData
extends PlayerData<EntityPlayerMP> {
    private Map<LivingMotion, StaticAnimation> livingMotionMap = Maps.newHashMap();
    private Map<LivingMotion, StaticAnimation> defaultLivingAnimations = Maps.newHashMap();
    private List<LivingMotion> modifiedLivingMotions = Lists.newArrayList();
    public static final UUID WEIGHT_PENALTY_MODIFIIER = UUID.fromString("414fed9e-e5e3-11ea-adc1-0242ac120002");
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    @Override
    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
        if (source.getSkillId() > Animations.BASIC_ATTACK_MIN && source.getSkillId() < Animations.BASIC_ATTACK_MAX) {
            float value;
            SkillContainer container = this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
            CapabilityItem itemCap = this.getHeldItemCapability(EnumHand.MAIN_HAND);
            if (itemCap != null && container.hasSkill(itemCap.getSpecialAttack(this)) && (value = container.getRemainCooldown() + amount) > 0.0f) {
                this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).setCooldown(value);
                ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.COOLDOWN, SkillSlot.WEAPON_SPECIAL_ATTACK.getIndex(), value, false), (EntityPlayerMP)this.orgEntity);
            }
        }
    }

    @Override
    public void onEntityJoinWorld(EntityPlayerMP entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.livingMotionMap.put(LivingMotion.IDLE, Animations.BIPED_IDLE);
        this.livingMotionMap.put(LivingMotion.WALKING, Animations.BIPED_WALK);
        this.livingMotionMap.put(LivingMotion.RUNNING, Animations.BIPED_RUN);
        this.livingMotionMap.put(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        this.livingMotionMap.put(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        this.livingMotionMap.put(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        this.livingMotionMap.put(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        this.livingMotionMap.put(LivingMotion.FALL, Animations.BIPED_FALL);
        this.livingMotionMap.put(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        this.livingMotionMap.put(LivingMotion.FLYING, Animations.BIPED_FLYING);
        this.livingMotionMap.put(LivingMotion.DEATH, Animations.BIPED_DEATH);
        for (Map.Entry<LivingMotion, StaticAnimation> entry : this.livingMotionMap.entrySet()) {
            this.defaultLivingAnimations.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void updateMotion() {
    }

    public void onHeldItemChange(CapabilityItem toChange, ItemStack stack, EnumHand hand) {
        CapabilityItem mainHandCap;
        CapabilityItem capabilityItem = mainHandCap = hand == EnumHand.MAIN_HAND ? toChange : this.getHeldItemCapability(EnumHand.MAIN_HAND);
        if (mainHandCap != null) {
            mainHandCap.onHeld(this);
        } else {
            this.getSkill(SkillSlot.WEAPON_GIMMICK).setSkill(null);
        }
        if (hand == EnumHand.MAIN_HAND) {
            this.getAttribute(SharedMonsterAttributes.field_188790_f).func_188479_b(WEIGHT_PENALTY_MODIFIIER);
            float weaponSpeed = (float)this.getAttribute(SharedMonsterAttributes.field_188790_f).func_111125_b();
            for (AttributeModifier attributeModifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
            }
            this.getAttribute(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight panelty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), weaponSpeed, this), 0));
        } else {
            this.getAttribute(ModAttributes.OFFHAND_ATTACK_SPEED).func_188479_b(WEIGHT_PENALTY_MODIFIIER);
            float weaponSpeed = (float)this.getAttribute(ModAttributes.OFFHAND_ATTACK_SPEED).func_111125_b();
            for (AttributeModifier attributeModifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
            }
            this.getAttribute(ModAttributes.OFFHAND_ATTACK_SPEED).func_111121_a(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight panelty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), weaponSpeed, this), 0));
            this.getAttribute(ModAttributes.OFFHAND_ATTACK_DAMAGE).func_188479_b(ATTACK_DAMAGE_MODIFIER);
            for (AttributeModifier attributeModifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                this.getAttribute(ModAttributes.OFFHAND_ATTACK_DAMAGE).func_111121_a(attributeModifier);
            }
        }
        this.modifiLivingMotions(mainHandCap);
    }

    @Override
    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EntityEquipmentSlot slotType) {
        IAttributeInstance mainhandAttackSpeed = this.getAttribute(SharedMonsterAttributes.field_188790_f);
        IAttributeInstance offhandAttackSpeed = this.getAttribute(ModAttributes.OFFHAND_ATTACK_SPEED);
        mainhandAttackSpeed.func_188479_b(WEIGHT_PENALTY_MODIFIIER);
        float mainWeaponSpeed = (float)mainhandAttackSpeed.func_111125_b();
        for (AttributeModifier attributeModifier : this.getOriginalEntity().func_184614_ca().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
            mainWeaponSpeed += (float)attributeModifier.func_111164_d();
        }
        mainhandAttackSpeed.func_111121_a(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight panelty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), mainWeaponSpeed, this), 0));
        offhandAttackSpeed.func_188479_b(WEIGHT_PENALTY_MODIFIIER);
        float offWeaponSpeed = (float)offhandAttackSpeed.func_111125_b();
        for (AttributeModifier attributeModifier : this.getOriginalEntity().func_184592_cb().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
            offWeaponSpeed += (float)attributeModifier.func_111164_d();
        }
        offhandAttackSpeed.func_111121_a(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight panelty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), offWeaponSpeed, this), 0));
    }

    public void modifiLivingMotions(CapabilityItem mainhand) {
        Map<LivingMotion, StaticAnimation> motionChanger;
        this.resetModifiedLivingMotions();
        if (mainhand != null && (motionChanger = mainhand.getLivingMotionChanges(this)) != null) {
            ArrayList motions = Lists.newArrayList();
            ArrayList animations = Lists.newArrayList();
            for (Map.Entry<LivingMotion, StaticAnimation> entry : motionChanger.entrySet()) {
                this.addModifiedLivingMotion(entry.getKey(), entry.getValue());
                motions.add(entry.getKey());
                animations.add(entry.getValue());
            }
            LivingMotion[] motionarr = motions.toArray(new LivingMotion[0]);
            StaticAnimation[] animationarr = animations.toArray(new StaticAnimation[0]);
            STCLivingMotionChange msg = new STCLivingMotionChange(((EntityPlayerMP)this.orgEntity).func_145782_y(), motionChanger.size());
            msg.setMotions(motionarr);
            msg.setAnimations(animationarr);
            ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (EntityPlayerMP)this.orgEntity);
            return;
        }
        STCLivingMotionChange msg = new STCLivingMotionChange(((EntityPlayerMP)this.orgEntity).func_145782_y(), 0);
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (EntityPlayerMP)this.orgEntity);
    }

    private void addModifiedLivingMotion(LivingMotion motion, StaticAnimation animation) {
        if (animation != null) {
            if (!this.modifiedLivingMotions.contains((Object)motion)) {
                this.modifiedLivingMotions.add(motion);
            }
            this.livingMotionMap.put(motion, animation);
        }
    }

    private void resetModifiedLivingMotions() {
        for (LivingMotion livingMotion : this.modifiedLivingMotions) {
            this.livingMotionMap.put(livingMotion, this.defaultLivingAnimations.get((Object)livingMotion));
        }
        this.modifiedLivingMotions.clear();
    }

    public void modifiLivingMotionToAll(STCLivingMotionChange packet) {
        LivingMotion[] motions = packet.getMotions();
        StaticAnimation[] animations = packet.getAnimations();
        for (int i = 0; i < motions.length; ++i) {
            this.addModifiedLivingMotion(motions[i], animations[i]);
        }
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(packet, (EntityPlayerMP)this.orgEntity);
    }

    public Set<Map.Entry<LivingMotion, StaticAnimation>> getLivingMotionEntrySet() {
        return this.livingMotionMap.entrySet();
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        super.playAnimationSynchronize(id, modifyTime);
        ModNetworkManager.sendToPlayer(new STCPlayAnimation(id, ((EntityPlayerMP)this.orgEntity).func_145782_y(), modifyTime), (EntityPlayerMP)this.orgEntity);
    }

    @Override
    public void changeYaw(float amount) {
        super.changeYaw(amount);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCNotifyPlayerYawChanged(((EntityPlayerMP)this.orgEntity).func_145782_y(), this.yaw), this.orgEntity);
        ModNetworkManager.sendToPlayer(new STCNotifyPlayerYawChanged(((EntityPlayerMP)this.orgEntity).func_145782_y(), this.yaw), (EntityPlayerMP)this.orgEntity);
    }

    @Override
    public EntityPlayerMP getOriginalEntity() {
        return (EntityPlayerMP)this.orgEntity;
    }

    @Override
    public void aboutToDeath() {
    }
}

