/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.player;

import java.util.UUID;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.entity.event.EntityEventListener;
import maninthehouse.epicfight.entity.event.PlayerEvent;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.gamedata.Skills;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public abstract class PlayerData<T extends EntityPlayer>
extends LivingData<T> {
    private static final UUID ACTION_EVENT_UUID = UUID.fromString("e6beeac4-77d2-11eb-9439-0242ac130002");
    protected float yaw;
    protected EntityEventListener eventListeners;
    protected int tickSinceLastAction;
    public SkillContainer[] skills;

    public PlayerData() {
        SkillSlot[] slots = SkillSlot.values();
        this.skills = new SkillContainer[SkillSlot.values().length];
        for (SkillSlot slot : slots) {
            this.skills[slot.getIndex()] = new SkillContainer(this);
        }
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.eventListeners = new EntityEventListener(this);
        this.skills[SkillSlot.DODGE.getIndex()].setSkill(Skills.ROLL);
        if (!((EntityPlayer)this.orgEntity).func_184212_Q().field_187234_c.containsKey(DataKeys.STUN_ARMOR.func_187155_a())) {
            ((EntityPlayer)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
        }
        this.tickSinceLastAction = 40;
        this.eventListeners.addEventListener(EntityEventListener.Event.ON_ACTION_SERVER_EVENT, PlayerEvent.makeEvent(ACTION_EVENT_UUID, player -> {
            player.tickSinceLastAction = 0;
            return false;
        }));
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.registerIfAbsent(ModAttributes.MAX_STUN_ARMOR);
        this.registerIfAbsent(ModAttributes.OFFHAND_ATTACK_DAMAGE);
        this.registerIfAbsent(ModAttributes.OFFHAND_ATTACK_SPEED);
    }

    @Override
    public void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animatorClient.addLivingAnimation(LivingMotion.RUNNING, Animations.BIPED_RUN);
        animatorClient.addLivingAnimation(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        animatorClient.addLivingAnimation(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        animatorClient.addLivingAnimation(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        animatorClient.addLivingAnimation(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.FLYING, Animations.BIPED_FLYING);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.JUMPING, Animations.BIPED_JUMP);
        animatorClient.addLivingMixAnimation(LivingMotion.BLOCKING, Animations.BIPED_BLOCK);
        animatorClient.addLivingMixAnimation(LivingMotion.AIMING, Animations.BIPED_BOW_AIM);
        animatorClient.addLivingMixAnimation(LivingMotion.RELOADING, Animations.BIPED_CROSSBOW_RELOAD);
        animatorClient.addLivingMixAnimation(LivingMotion.SHOTING, Animations.BIPED_BOW_REBOUND);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    public void changeYaw(float amount) {
        this.yaw = amount;
    }

    @Override
    public void updateOnServer() {
        super.updateOnServer();
        ++this.tickSinceLastAction;
        float stunArmor = this.getStunArmor();
        float maxStunArmor = this.getMaxStunArmor();
        if (stunArmor < maxStunArmor && this.tickSinceLastAction > 60) {
            float stunArmorFactor = 1.0f + stunArmor / maxStunArmor;
            float healthFactor = ((EntityPlayer)this.orgEntity).func_110143_aJ() / ((EntityPlayer)this.orgEntity).func_110138_aP();
            this.setStunArmor(stunArmor + maxStunArmor * 0.01f * healthFactor * stunArmorFactor);
        }
        if (maxStunArmor < stunArmor) {
            this.setStunArmor(maxStunArmor);
        }
    }

    @Override
    public void update() {
        if (((EntityPlayer)this.orgEntity).func_184187_bx() == null) {
            for (SkillContainer container : this.skills) {
                if (container == null) continue;
                container.update();
            }
        }
        super.update();
    }

    public SkillContainer getSkill(SkillSlot slot) {
        return this.skills[slot.getIndex()];
    }

    public SkillContainer getSkill(int slotIndex) {
        return this.skills[slotIndex];
    }

    public float getAttackSpeed() {
        return (float)this.getAttributeValue(SharedMonsterAttributes.field_188790_f);
    }

    public EntityEventListener getEventListener() {
        return this.eventListeners;
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (super.attackEntityFrom(damageSource, amount)) {
            this.tickSinceLastAction = 0;
            return true;
        }
        return false;
    }

    @Override
    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int id) {
        return IExtendedDamageSource.causePlayerDamage((EntityPlayer)this.orgEntity, stunType, damageType, id);
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (((EntityPlayer)this.orgEntity).func_184187_bx() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
        }
        return null;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_BIPED;
    }
}

