/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import io.netty.buffer.ByteBuf;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSReqSpawnInfo;
import maninthehouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;

public class ZombieData<T extends EntityZombie>
extends BipedMobData<T> {
    public ZombieData() {
        super(Faction.UNDEAD);
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((EntityZombie)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void postInit() {
        super.postInit();
        if (!this.isRemote()) {
            if (!((EntityZombie)this.orgEntity).func_98052_bS()) {
                ((EntityZombie)this.orgEntity).func_98053_h(this.isArmed());
            }
            if (((EntityZombie)this.orgEntity).func_70631_g_() && ((EntityZombie)this.orgEntity).func_184187_bx() instanceof EntityChicken && ((EntityZombie)this.orgEntity).func_184614_ca().func_77973_b() == Items.field_190931_a) {
                ((EntityZombie)this.orgEntity).func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151052_q));
            }
        } else {
            ModNetworkManager.sendToServer(new CTSReqSpawnInfo(((EntityZombie)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.registerIfAbsent(ModAttributes.MAX_STUN_ARMOR);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EntityZombie)this.orgEntity).func_110140_aT().func_111151_a(ModAttributes.IMPACT).func_111128_a(1.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ZOMBIE_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ZOMBIE_WALK);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public STCMobInitialSetting sendInitialInformationToClient() {
        STCMobInitialSetting packet = new STCMobInitialSetting(((EntityZombie)this.orgEntity).func_145782_y());
        PacketBuffer buf = packet.getBuffer();
        buf.writeBoolean(((EntityZombie)this.orgEntity).func_98052_bS());
        return packet;
    }

    @Override
    public void clientInitialSettings(ByteBuf buf) {
        AnimatorClient animator = this.getClientAnimator();
        if (buf.readBoolean()) {
            animator.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
            animator.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        }
    }

    @Override
    public void setAIAsUnarmed() {
        ((EntityZombie)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 1.0, false, Animations.ZOMBIE_CHASE, Animations.ZOMBIE_WALK, !((EntityZombie)this.orgEntity).func_70631_g_()));
        ((EntityZombie)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 1.75, true, MobAttackPatterns.ZOMBIE_NORAML));
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_BIPED_64_32_TEX;
    }
}

