/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIRangeAttack;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCPlayAnimationTarget;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;

public class WitchData
extends BipedMobData<EntityWitch> {
    private boolean isDrinking = false;

    public WitchData() {
        super(Faction.NATURAL);
    }

    @Override
    public void postInit() {
        super.resetCombatAI();
        ((EntityWitch)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new WitchThrowPotionGoal((IRangedAttackMob)this.orgEntity, this, 1.0, 60, 10.0f, 13));
    }

    @Override
    protected void initAI() {
        super.initAI();
    }

    @Override
    public void setAIAsUnarmed() {
    }

    @Override
    public void setAIAsArmed() {
    }

    public void setAIAsMounted() {
    }

    @Override
    public void setAIAsRange() {
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ILLAGER_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ILLAGER_WALK);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    protected void updateOnClient() {
        super.updateOnClient();
        if (this.isDrinking != ((EntityWitch)this.orgEntity).func_184730_o()) {
            if (!this.isDrinking && ((EntityWitch)this.orgEntity).func_110143_aJ() > 0.0f) {
                this.getClientAnimator().playMixLayerAnimation(Animations.WITCH_DRINKING);
            }
            this.isDrinking = ((EntityWitch)this.orgEntity).func_184730_o();
        }
    }

    @Override
    protected void updateOnServer() {
        super.updateOnServer();
        if (this.isDrinking != ((EntityWitch)this.orgEntity).func_184730_o()) {
            if (!this.isDrinking && ((EntityWitch)this.orgEntity).func_110143_aJ() > 0.0f) {
                this.getServerAnimator().playAnimation(Animations.DUMMY_ANIMATION, 0.0f);
            }
            this.isDrinking = ((EntityWitch)this.orgEntity).func_184730_o();
        }
    }

    public PotionType getPotionTypeWithTarget(EntityLivingBase target) {
        PotionType potiontype = PotionTypes.field_185252_x;
        double d1 = target.field_70165_t + target.field_70159_w - ((EntityWitch)this.orgEntity).field_70165_t;
        double d3 = target.field_70161_v + target.field_70179_y - ((EntityWitch)this.orgEntity).field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        if (f >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
            potiontype = PotionTypes.field_185246_r;
        } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
            potiontype = PotionTypes.field_185254_z;
        } else if (f <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && ((EntityWitch)this.orgEntity).func_70681_au().nextFloat() < 0.25f) {
            potiontype = PotionTypes.field_185226_I;
        }
        return potiontype;
    }

    public void throwPotion(EntityLivingBase target, float distanceFactor) {
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t + target.field_70159_w - ((EntityWitch)this.orgEntity).field_70165_t;
        double d2 = d0 - ((EntityWitch)this.orgEntity).field_70163_u;
        double d3 = target.field_70161_v + target.field_70179_y - ((EntityWitch)this.orgEntity).field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        EntityPotion entitypotion = new EntityPotion(((EntityWitch)this.orgEntity).field_70170_p, (EntityLivingBase)this.orgEntity, ((EntityWitch)this.orgEntity).func_184614_ca());
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        ((EntityWitch)this.orgEntity).field_70170_p.func_184148_a((EntityPlayer)null, ((EntityWitch)this.orgEntity).field_70165_t, ((EntityWitch)this.orgEntity).field_70163_u, ((EntityWitch)this.orgEntity).field_70161_v, SoundEvents.field_187924_gx, ((EntityWitch)this.orgEntity).func_184176_by(), 1.0f, 0.8f + ((EntityWitch)this.orgEntity).func_70681_au().nextFloat() * 0.4f);
        ((EntityWitch)this.orgEntity).field_70170_p.func_72838_d((Entity)entitypotion);
        ((EntityWitch)this.orgEntity).func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
    }

    @Override
    public VisibleMatrix4f getHeadMatrix(float partialTicks) {
        if (((EntityWitch)this.orgEntity).func_184730_o()) {
            return new VisibleMatrix4f();
        }
        return super.getHeadMatrix(partialTicks);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_WITCH;
    }

    class WitchThrowPotionGoal
    extends EntityAIRangeAttack {
        public WitchThrowPotionGoal(IRangedAttackMob attacker, BipedMobData<?> entitydata, double movespeed, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
            super(attacker, entitydata, Animations.BIPED_MOB_THROW, movespeed, maxAttackTime, maxAttackDistanceIn, animationFrame);
        }

        @Override
        public void func_75251_c() {
            this.entityHost.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }

        @Override
        public void func_75246_d() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entityHost.func_70661_as().func_75499_g();
            } else {
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((EntityWitch)WitchData.this.orgEntity).func_184730_o()) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (--this.rangedAttackTime == this.animationFrame && !this.entitydata.isInaction()) {
                this.entityHost.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)WitchData.this.getPotionTypeWithTarget(this.attackTarget)));
                this.entitydata.getServerAnimator().playAnimation(this.rangeAttackAnimation, 0.0f);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(this.rangeAttackAnimation.getId(), this.entityHost.func_145782_y(), 0.0f, this.attackTarget.func_145782_y()), (Entity)this.entityHost);
            } else if (this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                WitchData.this.throwPotion(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }
}

