/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import java.util.Iterator;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.MobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCPlayAnimationTarget;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.MathUtils;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class VexData
extends MobData<EntityVex> {
    private float prevPitchToTarget;
    private float pitchToTarget;

    public VexData() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        Iterator iterator = ((EntityVex)this.orgEntity).field_70714_bg.field_75782_a.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (count == 1) {
                iterator.remove();
                break;
            }
            ++count;
        }
        ((EntityVex)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new ChargeAttackGoal());
        ((EntityVex)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new StopStandGoal());
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Chest", "Wing_L", "Wing_R");
        animatorClient.addLivingAnimation(LivingMotion.FLOATING, Animations.VEX_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.VEX_DEATH);
        animatorClient.addLivingMixAnimation(LivingMotion.IDLE, Animations.VEX_FLIPPING);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void update() {
        this.prevPitchToTarget = this.pitchToTarget;
        super.update();
    }

    @Override
    public void updateMotion() {
        this.currentMotion = LivingMotion.FLOATING;
        this.currentMixMotion = LivingMotion.IDLE;
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        this.animator.playAnimation(id, modifyTime);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(id, ((EntityVex)this.orgEntity).func_145782_y(), modifyTime, this.getAttackTarget().func_145782_y()), this.orgEntity);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_VEX;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return Animations.VEX_HIT;
    }

    @Override
    public VisibleMatrix4f getHeadMatrix(float partialTicks) {
        return super.getHeadMatrix(partialTicks);
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        if (((EntityVex)this.orgEntity).func_190647_dj()) {
            if (this.pitchToTarget == 0.0f && this.getAttackTarget() != null) {
                EntityLivingBase target = this.getAttackTarget();
                double d0 = ((EntityVex)this.orgEntity).field_70165_t - target.field_70165_t;
                double d1 = ((EntityVex)this.orgEntity).field_70163_u - (target.field_70163_u + (double)target.field_70131_O * 0.5);
                double d2 = ((EntityVex)this.orgEntity).field_70161_v - target.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                this.pitchToTarget = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
            }
        } else {
            this.pitchToTarget = 0.0f;
        }
        VisibleMatrix4f.rotate((float)Math.toRadians(MathUtils.interpolateRotation(this.prevPitchToTarget, this.pitchToTarget, partialTicks)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
        return mat;
    }

    class ChargeAttackGoal
    extends EntityAIBase {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (((EntityVex)VexData.this.orgEntity).func_70638_az() != null && !VexData.this.inaction && ((EntityVex)VexData.this.orgEntity).func_70681_au().nextInt(10) == 0) {
                double distance = ((EntityVex)VexData.this.orgEntity).func_70068_e((Entity)((EntityVex)VexData.this.orgEntity).func_70638_az());
                return distance < 50.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.chargingCounter > 0;
        }

        public void func_75249_e() {
            EntityLivingBase target = VexData.this.getAttackTarget();
            VexData.this.playAnimationSynchronize(Animations.VEX_CHARGING, 0.0f);
            ((EntityVex)VexData.this.orgEntity).func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
            ((EntityVex)VexData.this.orgEntity).func_190648_a(true);
            double d0 = ((EntityVex)((VexData)VexData.this).orgEntity).field_70165_t - target.field_70165_t;
            double d1 = ((EntityVex)((VexData)VexData.this).orgEntity).field_70163_u - (target.field_70163_u + (double)target.field_70131_O * 0.5);
            double d2 = ((EntityVex)((VexData)VexData.this).orgEntity).field_70161_v - target.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            VexData.this.pitchToTarget = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
            this.chargingCounter = 20;
        }

        public void func_75251_c() {
            ((EntityVex)VexData.this.orgEntity).func_190648_a(false);
            VexData.this.pitchToTarget = 0.0f;
        }

        public void func_75246_d() {
            --this.chargingCounter;
        }
    }

    class StopStandGoal
    extends EntityAIBase {
        public StopStandGoal() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return VexData.this.inaction;
        }

        public void func_75249_e() {
            ((EntityVex)((VexData)VexData.this).orgEntity).field_70159_w = 0.0;
            ((EntityVex)((VexData)VexData.this).orgEntity).field_70181_x = 0.0;
            ((EntityVex)((VexData)VexData.this).orgEntity).field_70179_y = 0.0;
            ((EntityVex)VexData.this.orgEntity).func_70661_as().func_75499_g();
        }
    }
}

